# Packaging support file
#
# Manage the packaging of the VM executable, sources and headers
# This support file defines
#   - Several components to package
#   - Their packaging with CPack

make_directory("build/packages")

# Selecting files to include in the packages

configure_installables(bin)

install(FILES
  ${CMAKE_CURRENT_BINARY_DIR}/build/include/pharovm/config.h
  DESTINATION include/pharovm
  COMPONENT include)

install(
    DIRECTORY "${CMAKE_CURRENT_SOURCE_DIR}/include/pharovm"
    DESTINATION include
    USE_SOURCE_PERMISSIONS
    COMPONENT include
    FILES_MATCHING PATTERN *.h)

install(
    DIRECTORY "${CMAKE_CURRENT_SOURCE_DIR}/include/common/"
    DESTINATION include/pharovm
    USE_SOURCE_PERMISSIONS
    COMPONENT include
    FILES_MATCHING PATTERN *.h)

install(DIRECTORY
    "${CMAKE_CURRENT_SOURCE_DIR}/cmake"
    "${CMAKE_CURRENT_SOURCE_DIR}/include"
    "${CMAKE_CURRENT_SOURCE_DIR}/packaging"
    "${CMAKE_CURRENT_SOURCE_DIR}/plugins"
    "${CMAKE_CURRENT_SOURCE_DIR}/resources"
    "${CMAKE_CURRENT_SOURCE_DIR}/scripts"
    "${CMAKE_CURRENT_SOURCE_DIR}/src"
    "${CMAKE_CURRENT_SOURCE_DIR}/ffiTestLibrary"
    DESTINATION pharo-vm
    USE_SOURCE_PERMISSIONS
    COMPONENT c-src
)

install(FILES
	"${CMAKE_CURRENT_BINARY_DIR}/version.info"
	DESTINATION pharo-vm
	COMPONENT c-src)

#List all cmake files
file(GLOB SUPPORT_CMAKE_FILES
  "${CMAKE_CURRENT_SOURCE_DIR}/*.cmake"
)

install(FILES
    "CMakeLists.txt"
    ${SUPPORT_CMAKE_FILES}
    DESTINATION pharo-vm
    COMPONENT c-src
)

#Define generated files as elements in the c-src component for packaging
install(
	DIRECTORY "${GENERATED_SOURCE_DIR}/generated/"
	DESTINATION pharo-vm/generated/
	USE_SOURCE_PERMISSIONS
	COMPONENT c-src)

install(
	DIRECTORY "${PHARO_CURRENT_GENERATED}/vm/include/"
	DESTINATION include/pharovm
	USE_SOURCE_PERMISSIONS
	COMPONENT include
	FILES_MATCHING PATTERN *.h)

set(CPACK_PACKAGE_DESCRIPTION "${APPNAME} Headless VM for ${FULL_PLATFORM_NAME}")
set(CPACK_PACKAGE_VENDOR "${APPNAME}")
set(CPACK_PACKAGE_HOMEPAGE_URL "https://pharo.org")

if(ALWAYS_INTERACTIVE)
	set(CPACK_PACKAGE_FILE_NAME "${APPNAME}VM-${PharoVM_VERSION_STRING_FULL}-${FULL_PLATFORM_NAME}-stockReplacement")
else()
	set(CPACK_PACKAGE_FILE_NAME "${APPNAME}VM-${PharoVM_VERSION_STRING_FULL}-${FULL_PLATFORM_NAME}")
endif()

set(CPACK_PACKAGE_DIRECTORY "${CMAKE_CURRENT_BINARY_DIR}/build/packages")
set(CPACK_PACKAGE_CHECKSUM "SHA1")
set(CPACK_GENERATOR "ZIP" "TGZ")
set(CPACK_INCLUDE_TOPLEVEL_DIRECTORY TRUE)

#Tell CPACK to archive each sub component separately
set(CPACK_ARCHIVE_COMPONENT_INSTALL ON)

set(CPACK_SOURCE_GENERATOR "TGZ")
set(CPACK_SOURCE_IGNORE_FILES
  ".git/;${CMAKE_CURRENT_BINARY_DIR}"
)

include (CPack)
