/* Automatically generated by
	SmartSyntaxPluginCodeGenerator VMMaker.oscog-eem.2495 uuid: fcbf4c90-4c50-4ff3-8690-0edfded4f9c4
   from
	SocketPlugin VMMaker.oscog-eem.2495 uuid: fcbf4c90-4c50-4ff3-8690-0edfded4f9c4
 */
static char __buildInfo[] = "SocketPlugin VMMaker.oscog-eem.2495 uuid: fcbf4c90-4c50-4ff3-8690-0edfded4f9c4 " __DATE__ ;



#include "config.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* Default EXPORT macro that does nothing (see comment in sq.h): */
#define EXPORT(returnType) returnType

/* Do not include the entire sq.h file but just those parts needed. */
#include "sqConfig.h"			/* Configuration options */
#include "virtualMachine.h"	/*  The virtual machine proxy definition */
#include "sqPlatformSpecific.h"	/* Platform specific definitions */

#define true 1
#define false 0
#define null 0  /* using 'null' because nil is predefined in Think C */
#ifdef SQUEAK_BUILTIN_PLUGIN
# undef EXPORT
# define EXPORT(returnType) static returnType
#endif

#include "SocketPlugin.h"
#include "memoryAccess.h"


/*** Constants ***/
#define PrimErrBadArgument 3


/*** Function Prototypes ***/
EXPORT(const char*) getModuleName(void);
EXPORT(sqInt) initialiseModule(void);
static sqInt intToNetAddress(sqInt addr);
EXPORT(sqInt) moduleUnloaded(char *aModuleName);
static sqInt netAddressToInt(unsigned char *ptrToByteArray);
EXPORT(sqInt) primitiveInitializeNetwork(void);
EXPORT(sqInt) primitiveResolverAbortLookup(void);
EXPORT(sqInt) primitiveResolverAddressLookupResult(void);
EXPORT(sqInt) primitiveResolverError(void);
EXPORT(sqInt) primitiveResolverGetAddressInfo(void);
EXPORT(sqInt) primitiveResolverGetAddressInfoFamily(void);
EXPORT(sqInt) primitiveResolverGetAddressInfoNext(void);
EXPORT(sqInt) primitiveResolverGetAddressInfoProtocol(void);
EXPORT(sqInt) primitiveResolverGetAddressInfoResult(void);
EXPORT(sqInt) primitiveResolverGetAddressInfoSize(void);
EXPORT(sqInt) primitiveResolverGetAddressInfoType(void);
EXPORT(sqInt) primitiveResolverGetNameInfo(void);
EXPORT(sqInt) primitiveResolverGetNameInfoHostResult(void);
EXPORT(sqInt) primitiveResolverGetNameInfoHostSize(void);
EXPORT(sqInt) primitiveResolverGetNameInfoServiceResult(void);
EXPORT(sqInt) primitiveResolverGetNameInfoServiceSize(void);
EXPORT(sqInt) primitiveResolverHostNameResult(void);
EXPORT(sqInt) primitiveResolverHostNameSize(void);
EXPORT(sqInt) primitiveResolverLocalAddress(void);
EXPORT(sqInt) primitiveResolverNameLookupResult(void);
EXPORT(sqInt) primitiveResolverStartAddressLookup(void);
EXPORT(sqInt) primitiveResolverStartNameLookup(void);
EXPORT(sqInt) primitiveResolverStatus(void);
EXPORT(sqInt) primitiveSocketAbortConnection(void);
EXPORT(sqInt) primitiveSocketAccept(void);
EXPORT(sqInt) primitiveSocketAccept3Semaphores(void);
EXPORT(sqInt) primitiveSocketAddressGetPort(void);
EXPORT(sqInt) primitiveSocketAddressSetPort(void);
EXPORT(sqInt) primitiveSocketBindTo(void);
EXPORT(sqInt) primitiveSocketBindToPort(void);
EXPORT(sqInt) primitiveSocketCloseConnection(void);
EXPORT(sqInt) primitiveSocketConnectionStatus(void);
EXPORT(sqInt) primitiveSocketConnectTo(void);
EXPORT(sqInt) primitiveSocketConnectToPort(void);
EXPORT(sqInt) primitiveSocketCreate(void);
EXPORT(sqInt) primitiveSocketCreate3Semaphores(void);
EXPORT(sqInt) primitiveSocketCreateRAW(void);
EXPORT(sqInt) primitiveSocketDestroy(void);
EXPORT(sqInt) primitiveSocketError(void);
EXPORT(sqInt) primitiveSocketGetOptions(void);
EXPORT(sqInt) primitiveSocketListenOnPort(void);
EXPORT(sqInt) primitiveSocketListenOnPortBacklog(void);
EXPORT(sqInt) primitiveSocketListenOnPortBacklogInterface(void);
EXPORT(sqInt) primitiveSocketListenWithBacklog(void);
EXPORT(sqInt) primitiveSocketListenWithOrWithoutBacklog(void);
EXPORT(sqInt) primitiveSocketLocalAddress(void);
EXPORT(sqInt) primitiveSocketLocalAddressResult(void);
EXPORT(sqInt) primitiveSocketLocalAddressSize(void);
EXPORT(sqInt) primitiveSocketLocalPort(void);
EXPORT(sqInt) primitiveSocketReceiveDataAvailable(void);
EXPORT(sqInt) primitiveSocketReceiveDataBufCount(void);
EXPORT(sqInt) primitiveSocketReceiveUDPDataBufCount(void);
EXPORT(sqInt) primitiveSocketRemoteAddress(void);
EXPORT(sqInt) primitiveSocketRemoteAddressResult(void);
EXPORT(sqInt) primitiveSocketRemoteAddressSize(void);
EXPORT(sqInt) primitiveSocketRemotePort(void);
EXPORT(sqInt) primitiveSocketSendDataBufCount(void);
EXPORT(sqInt) primitiveSocketSendDone(void);
EXPORT(sqInt) primitiveSocketSendUDPDataBufCount(void);
EXPORT(sqInt) primitiveSocketSetOptions(void);
EXPORT(sqInt) setInterpreter(struct VirtualMachine *anInterpreter);
EXPORT(sqInt) shutdownModule(void);
static sqInt socketRecordSize(void);
static SocketPtr socketValueOf(sqInt socketOop);
static sqInt sqAssert(sqInt aBool);


/*** Variables ***/

#if !defined(SQUEAK_BUILTIN_PLUGIN)
static sqInt (*byteSizeOf)(sqInt oop);
static sqInt (*classArray)(void);
static sqInt (*classByteArray)(void);
static sqInt (*classString)(void);
static sqInt (*failed)(void);
static sqInt (*falseObject)(void);
static void * (*firstIndexableField)(sqInt oop);
static sqInt (*instantiateClassindexableSize)(sqInt classPointer, sqInt size);
static sqInt (*integerObjectOf)(sqInt value);
static void * (*ioLoadFunctionFrom)(char *functionName, char *moduleName);
static sqInt (*isBytes)(sqInt oop);
static sqInt (*isIntegerObject)(sqInt objectPointer);
static sqInt (*isWords)(sqInt oop);
static sqInt (*isWordsOrBytes)(sqInt oop);
static sqInt (*methodArgumentCount)(void);
static sqInt (*pop)(sqInt nItems);
static void (*popthenPush)(sqInt nItems, sqInt oop);
static sqInt (*popRemappableOop)(void);
static sqInt (*primitiveFail)(void);
static sqInt (*primitiveFailFor)(sqInt reasonCode);
static void (*pushRemappableOop)(sqInt oop);
static sqInt (*slotSizeOf)(sqInt oop);
static sqInt (*stackIntegerValue)(sqInt offset);
static sqInt (*stackValue)(sqInt offset);
static sqInt (*storePointerofObjectwithValue)(sqInt index, sqInt oop, sqInt valuePointer);
static sqInt (*success)(sqInt aBoolean);
static sqInt (*trueObject)(void);
#else /* !defined(SQUEAK_BUILTIN_PLUGIN) */
extern sqInt byteSizeOf(sqInt oop);
extern sqInt classArray(void);
extern sqInt classByteArray(void);
extern sqInt classString(void);
extern sqInt failed(void);
extern sqInt falseObject(void);
extern void * firstIndexableField(sqInt oop);
extern sqInt instantiateClassindexableSize(sqInt classPointer, sqInt size);
extern sqInt integerObjectOf(sqInt value);
extern void * ioLoadFunctionFrom(char *functionName, char *moduleName);
extern sqInt isBytes(sqInt oop);
#if !defined(isIntegerObject)
extern sqInt isIntegerObject(sqInt objectPointer);
#endif
extern sqInt isWords(sqInt oop);
extern sqInt isWordsOrBytes(sqInt oop);
extern sqInt methodArgumentCount(void);
extern sqInt pop(sqInt nItems);
extern void popthenPush(sqInt nItems, sqInt oop);
extern sqInt popRemappableOop(void);
extern sqInt primitiveFail(void);
extern sqInt primitiveFailFor(sqInt reasonCode);
extern void pushRemappableOop(sqInt oop);
extern sqInt slotSizeOf(sqInt oop);
extern sqInt stackIntegerValue(sqInt offset);
extern sqInt stackValue(sqInt offset);
extern sqInt storePointerofObjectwithValue(sqInt index, sqInt oop, sqInt valuePointer);
extern sqInt success(sqInt aBoolean);
extern sqInt trueObject(void);
extern
#endif
struct VirtualMachine* interpreterProxy;
static const char *moduleName =
#ifdef SQUEAK_BUILTIN_PLUGIN
	"SocketPlugin VMMaker.oscog-eem.2495 (i)"
#else
	"SocketPlugin VMMaker.oscog-eem.2495 (e)"
#endif
;


/*	Note: This is hardcoded so it can be run from Squeak.
	The module name is used for validating a module *after*
	it is loaded to check if it does really contain the module
	we're thinking it contains. This is important! */

	/* InterpreterPlugin>>#getModuleName */
EXPORT(const char*)
getModuleName(void)
{
	return moduleName;
}

	/* SocketPlugin>>#initialiseModule */
EXPORT(sqInt)
initialiseModule(void)
{
	return socketInit();
}


/*	Convert the given 32-bit integer into an internet network address
	represented as a four-byte ByteArray.
 */

	/* SocketPlugin>>#intToNetAddress: */
static sqInt
intToNetAddress(sqInt addr)
{
	char *naPtr;
	sqInt netAddressOop;

	netAddressOop = instantiateClassindexableSize(classByteArray(), 4);
	naPtr = ((char *)firstIndexableField(netAddressOop));
	naPtr[0] = (((char) ((((usqInt) addr) >> 24) & 0xFF)));
	naPtr[1] = (((char) ((((usqInt) addr) >> 16) & 0xFF)));
	naPtr[2] = (((char) ((((usqInt) addr) >> 8) & 0xFF)));
	naPtr[3] = (((char) (addr & 0xFF)));
	return netAddressOop;
}


/*	The module with the given name was just unloaded.
	Make sure we have no dangling references. */

	/* SocketPlugin>>#moduleUnloaded: */
EXPORT(sqInt)
moduleUnloaded(char *aModuleName)
{
	return 0;
}


/*	Convert the given internet network address (represented as a four-byte
	ByteArray) into a 32-bit integer. Fail if the given ptrToByteArray does
	not appear to point to a four-byte ByteArray.
 */

	/* SocketPlugin>>#netAddressToInt: */
static sqInt
netAddressToInt(unsigned char *ptrToByteArray)
{
	sqInt sz;

	sz = byteSizeOf(((sqInt)(sqIntptr_t)(ptrToByteArray) - BaseHeaderSize));
	if (!(sz == 4)) {
		return primitiveFail();
	}
	return (((ptrToByteArray[3]) + (((usqInt)((ptrToByteArray[2])) << 8))) + (((usqInt)((ptrToByteArray[1])) << 16))) + (((usqInt)((ptrToByteArray[0])) << 24));
}


	/* SocketPlugin>>#primitiveInitializeNetwork: */
EXPORT(sqInt)
primitiveInitializeNetwork(void)
{
	sqInt err;
	sqInt resolverSemaIndex;

	if (!(isIntegerObject(stackValue(0)))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	resolverSemaIndex = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	err = sqNetworkInit(resolverSemaIndex);
	success(err == 0);
	if (!(failed())) {
		pop(1);
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverAbortLookup */
EXPORT(sqInt)
primitiveResolverAbortLookup(void)
{
	sqResolverAbort();
	return null;
}

	/* SocketPlugin>>#primitiveResolverAddressLookupResult */
EXPORT(sqInt)
primitiveResolverAddressLookupResult(void)
{
	sqInt s;
	sqInt sz;

	s = 0;
	sz = sqResolverAddrLookupResultSize();
	if (!(failed())) {
		s = instantiateClassindexableSize(classString(), sz);
		sqResolverAddrLookupResult(((char *)firstIndexableField(s)), sz);
	}
	if (!(failed())) {
		popthenPush(1, s);
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverError */
EXPORT(sqInt)
primitiveResolverError(void)
{
	popthenPush(1, integerObjectOf((sqResolverError())));
	return null;
}

	/* SocketPlugin>>#primitiveResolverGetAddressInfoHost:service:flags:family:type:protocol: */
EXPORT(sqInt)
primitiveResolverGetAddressInfo(void)
{
	sqInt family;
	sqInt flags;
	char *hostName;
	sqInt hostSize;
	sqInt protocol;
	char *servName;
	sqInt servSize;
	sqInt type;

	if (!((isBytes(stackValue(5)))
		 && ((isBytes(stackValue(4)))
		 && ((isIntegerObject(stackValue(3)))
		 && ((isIntegerObject(stackValue(2)))
		 && ((isIntegerObject(stackValue(1)))
		 && (isIntegerObject(stackValue(0))))))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	hostName = ((char *) (firstIndexableField(stackValue(5))));
	servName = ((char *) (firstIndexableField(stackValue(4))));
	flags = stackIntegerValue(3);
	family = stackIntegerValue(2);
	type = stackIntegerValue(1);
	protocol = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	if (!(failed())) {
		hostSize = byteSizeOf(((sqInt)(sqIntptr_t)(hostName) - BaseHeaderSize));
		servSize = byteSizeOf(((sqInt)(sqIntptr_t)(servName) - BaseHeaderSize));
		sqResolverGetAddressInfoHostSizeServiceSizeFlagsFamilyTypeProtocol(hostName, hostSize, servName, servSize, flags, family, type, protocol);
	}
	if (!(failed())) {
		pop(6);
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverGetAddressInfoFamily */
EXPORT(sqInt)
primitiveResolverGetAddressInfoFamily(void)
{
	sqInt family;

	if (!(failed())) {
		family = sqResolverGetAddressInfoFamily();
		if (!(failed())) {
			popthenPush(1, integerObjectOf(family));
		}
		return null;
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverGetAddressInfoNext */
EXPORT(sqInt)
primitiveResolverGetAddressInfoNext(void)
{
	sqInt more;

	more = sqResolverGetAddressInfoNext();
	if (failed()) {
		return null;
	}
	if (!(failed())) {
		popthenPush(1, ((more) ? trueObject() : falseObject()));
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverGetAddressInfoProtocol */
EXPORT(sqInt)
primitiveResolverGetAddressInfoProtocol(void)
{
	sqInt protocol;

	if (!(failed())) {
		protocol = sqResolverGetAddressInfoProtocol();
		if (!(failed())) {
			popthenPush(1, integerObjectOf(protocol));
		}
		return null;
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverGetAddressInfoResult: */
EXPORT(sqInt)
primitiveResolverGetAddressInfoResult(void)
{
	sqInt addrSize;
	char *socketAddress;

	if (!(isBytes(stackValue(0)))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socketAddress = ((char *) (firstIndexableField(stackValue(0))));
	if (failed()) {
		return null;
	}
	if (!(failed())) {
		addrSize = byteSizeOf(((sqInt)(sqIntptr_t)(socketAddress) - BaseHeaderSize));
		sqResolverGetAddressInfoResultSize(socketAddress, addrSize);
	}
	if (!(failed())) {
		pop(1);
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverGetAddressInfoSize */
EXPORT(sqInt)
primitiveResolverGetAddressInfoSize(void)
{
	sqInt size;

	if (!(failed())) {
		size = sqResolverGetAddressInfoSize();
		if (!(failed())) {
			popthenPush(1, integerObjectOf(size));
		}
		return null;
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverGetAddressInfoType */
EXPORT(sqInt)
primitiveResolverGetAddressInfoType(void)
{
	sqInt type;

	if (!(failed())) {
		type = sqResolverGetAddressInfoType();
		if (!(failed())) {
			popthenPush(1, integerObjectOf(type));
		}
		return null;
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverGetNameInfo:flags: */
EXPORT(sqInt)
primitiveResolverGetNameInfo(void)
{
	char *addrBase;
	sqInt addrSize;
	sqInt flags;
	sqInt socketAddress;

	if (!(isIntegerObject(stackValue(0)))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socketAddress = stackValue(1);
	flags = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	if (!(failed())) {
		addrSize = byteSizeOf(socketAddress);
		addrBase = ((char *) (firstIndexableField(socketAddress)));
		sqResolverGetNameInfoSizeFlags(addrBase, addrSize, flags);
	}
	if (!(failed())) {
		pop(2);
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverGetNameInfoHostResult: */
EXPORT(sqInt)
primitiveResolverGetNameInfoHostResult(void)
{
	sqInt addrSize;
	char *socketName;

	if (!(isBytes(stackValue(0)))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socketName = ((char *) (firstIndexableField(stackValue(0))));
	if (failed()) {
		return null;
	}
	if (!(failed())) {
		addrSize = byteSizeOf(((sqInt)(sqIntptr_t)(socketName) - BaseHeaderSize));
		sqResolverGetNameInfoHostResultSize(socketName, addrSize);
	}
	if (!(failed())) {
		pop(1);
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverGetNameInfoHostSize */
EXPORT(sqInt)
primitiveResolverGetNameInfoHostSize(void)
{
	sqInt size;

	if (!(failed())) {
		size = sqResolverGetNameInfoHostSize();
		if (!(failed())) {
			popthenPush(1, integerObjectOf(size));
		}
		return null;
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverGetNameInfoServiceResult: */
EXPORT(sqInt)
primitiveResolverGetNameInfoServiceResult(void)
{
	sqInt addrSize;
	char *socketName;

	if (!(isBytes(stackValue(0)))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socketName = ((char *) (firstIndexableField(stackValue(0))));
	if (failed()) {
		return null;
	}
	if (!(failed())) {
		addrSize = byteSizeOf(((sqInt)(sqIntptr_t)(socketName) - BaseHeaderSize));
		sqResolverGetNameInfoServiceResultSize(socketName, addrSize);
	}
	if (!(failed())) {
		pop(1);
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverGetNameInfoServiceSize */
EXPORT(sqInt)
primitiveResolverGetNameInfoServiceSize(void)
{
	sqInt size;

	if (!(failed())) {
		size = sqResolverGetNameInfoServiceSize();
		if (!(failed())) {
			popthenPush(1, integerObjectOf(size));
		}
		return null;
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverHostNameResult: */
EXPORT(sqInt)
primitiveResolverHostNameResult(void)
{
	sqInt nameSize;
	char *nameString;

	if (!(isBytes(stackValue(0)))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	nameString = ((char *) (firstIndexableField(stackValue(0))));
	if (failed()) {
		return null;
	}
	if (!(failed())) {
		nameSize = byteSizeOf(((sqInt)(sqIntptr_t)(nameString) - BaseHeaderSize));
		sqResolverHostNameResultSize(nameString, nameSize);
	}
	if (!(failed())) {
		pop(1);
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverHostNameSize */
EXPORT(sqInt)
primitiveResolverHostNameSize(void)
{
	sqInt size;

	if (!(failed())) {
		size = sqResolverHostNameSize();
		if (!(failed())) {
			popthenPush(1, integerObjectOf(size));
			return null;
		}
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverLocalAddress */
EXPORT(sqInt)
primitiveResolverLocalAddress(void)
{
	sqInt addr;
	sqInt _return_value;

	addr = sqResolverLocalAddress();
	if (!(failed())) {
		_return_value = intToNetAddress(addr);
		if (!(failed())) {
			popthenPush(1, _return_value);
		}
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverNameLookupResult */
EXPORT(sqInt)
primitiveResolverNameLookupResult(void)
{
	sqInt addr;
	sqInt _return_value;

	addr = sqResolverNameLookupResult();
	if (!(failed())) {
		_return_value = intToNetAddress(addr);
		if (!(failed())) {
			popthenPush(1, _return_value);
		}
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverStartAddressLookup: */
EXPORT(sqInt)
primitiveResolverStartAddressLookup(void)
{
	sqInt addr;
	char *address;
	sqInt sz;

	if (!(isBytes(stackValue(0)))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	address = ((char *) (firstIndexableField(stackValue(0))));
	if (failed()) {
		return null;
	}
	/* begin netAddressToInt: */
	sz = byteSizeOf(((sqInt)(sqIntptr_t)((((unsigned char *) address))) - BaseHeaderSize));
	if (!(sz == 4)) {
		addr = primitiveFail();
		goto l1;
	}
	addr = ((((((unsigned char *) address))[3]) + (((usqInt)(((((unsigned char *) address))[2])) << 8))) + (((usqInt)(((((unsigned char *) address))[1])) << 16))) + (((usqInt)(((((unsigned char *) address))[0])) << 24));
	l1:	/* end netAddressToInt: */;
	if (!(failed())) {
		sqResolverStartAddrLookup(addr);
	}
	if (!(failed())) {
		pop(1);
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverStartNameLookup: */
EXPORT(sqInt)
primitiveResolverStartNameLookup(void)
{
	char *name;
	sqInt sz;

	if (!(isBytes(stackValue(0)))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	name = ((char *) (firstIndexableField(stackValue(0))));
	if (failed()) {
		return null;
	}
	if (!(failed())) {
		sz = byteSizeOf(((sqInt)(sqIntptr_t)(name) - BaseHeaderSize));
		sqResolverStartNameLookup(name, sz);
	}
	if (!(failed())) {
		pop(1);
	}
	return null;
}

	/* SocketPlugin>>#primitiveResolverStatus */
EXPORT(sqInt)
primitiveResolverStatus(void)
{
	sqInt status;

	status = sqResolverStatus();
	if (!(failed())) {
		popthenPush(1, integerObjectOf(status));
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketAbortConnection: */
EXPORT(sqInt)
primitiveSocketAbortConnection(void)
{
	SocketPtr s;
	sqInt socket;

	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (!(failed())) {
		sqSocketAbortConnection(s);
	}
	if (!(failed())) {
		pop(1);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketAcceptFrom:rcvBufferSize:sndBufSize:semaIndex: */
EXPORT(sqInt)
primitiveSocketAccept(void)
{
	sqInt recvBufSize;
	SocketPtr s;
	sqInt semaIndex;
	sqInt sendBufSize;
	SocketPtr serverSocket;
	sqInt socketOop;
	sqInt sockHandle;

	socketOop = 0;
	if (!((isIntegerObject(stackValue(2)))
		 && ((isIntegerObject(stackValue(1)))
		 && (isIntegerObject(stackValue(0)))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	sockHandle = stackValue(3);
	recvBufSize = stackIntegerValue(2);
	sendBufSize = stackIntegerValue(1);
	semaIndex = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(sockHandle))
	 && ((byteSizeOf(sockHandle)) == (sizeof(SQSocket)))) {
		serverSocket = ((SocketPtr) (firstIndexableField(sockHandle)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		serverSocket = null;
	}
	if (!(failed())) {
		socketOop = instantiateClassindexableSize(classByteArray(), sizeof(SQSocket));
		/* begin socketValueOf: */
		if ((isBytes(socketOop))
		 && ((byteSizeOf(socketOop)) == (sizeof(SQSocket)))) {
			s = ((SocketPtr) (firstIndexableField(socketOop)));
		}
		else {
			primitiveFailFor(PrimErrBadArgument);
			s = null;
		}
		sqSocketAcceptFromRecvBytesSendBytesSemaID(s, serverSocket, recvBufSize, sendBufSize, semaIndex);
	}
	if (!(failed())) {
		popthenPush(5, socketOop);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketAcceptFrom:rcvBufferSize:sndBufSize:semaIndex:readSemaIndex:writeSemaIndex: */
EXPORT(sqInt)
primitiveSocketAccept3Semaphores(void)
{
	sqInt aReadSema;
	sqInt aWriteSema;
	sqInt recvBufSize;
	SocketPtr s;
	sqInt semaIndex;
	sqInt sendBufSize;
	SocketPtr serverSocket;
	sqInt socketOop;
	sqInt sockHandle;

	socketOop = 0;
	if (!((isIntegerObject(stackValue(4)))
		 && ((isIntegerObject(stackValue(3)))
		 && ((isIntegerObject(stackValue(2)))
		 && ((isIntegerObject(stackValue(1)))
		 && (isIntegerObject(stackValue(0)))))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	sockHandle = stackValue(5);
	recvBufSize = stackIntegerValue(4);
	sendBufSize = stackIntegerValue(3);
	semaIndex = stackIntegerValue(2);
	aReadSema = stackIntegerValue(1);
	aWriteSema = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(sockHandle))
	 && ((byteSizeOf(sockHandle)) == (sizeof(SQSocket)))) {
		serverSocket = ((SocketPtr) (firstIndexableField(sockHandle)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		serverSocket = null;
	}
	if (!(failed())) {
		socketOop = instantiateClassindexableSize(classByteArray(), sizeof(SQSocket));
		/* begin socketValueOf: */
		if ((isBytes(socketOop))
		 && ((byteSizeOf(socketOop)) == (sizeof(SQSocket)))) {
			s = ((SocketPtr) (firstIndexableField(socketOop)));
		}
		else {
			primitiveFailFor(PrimErrBadArgument);
			s = null;
		}
		sqSocketAcceptFromRecvBytesSendBytesSemaIDReadSemaIDWriteSemaID(s, serverSocket, recvBufSize, sendBufSize, semaIndex, aReadSema, aWriteSema);
	}
	if (!(failed())) {
		popthenPush(7, socketOop);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketAddressGetPort */
EXPORT(sqInt)
primitiveSocketAddressGetPort(void)
{
	sqInt addr;
	char *addrBase;
	sqInt addrSize;
	sqInt port;

	addr = stackValue(0);
	if (failed()) {
		return null;
	}
	addrSize = byteSizeOf(addr);
	addrBase = ((char *) (firstIndexableField(addr)));
	if (!(failed())) {
		port = sqSocketAddressSizeGetPort(addrBase, addrSize);
		if (!(failed())) {
			popthenPush(1, integerObjectOf(port));
			return null;
		}
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketAddressSetPort: */
EXPORT(sqInt)
primitiveSocketAddressSetPort(void)
{
	sqInt addr;
	char *addrBase;
	sqInt addrSize;
	sqInt portNumber;

	if (!(isIntegerObject(stackValue(0)))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	portNumber = stackIntegerValue(0);
	addr = stackValue(1);
	if (failed()) {
		return null;
	}
	addrSize = byteSizeOf(addr);
	addrBase = ((char *) (firstIndexableField(addr)));
	if (!(failed())) {
		sqSocketAddressSizeSetPort(addrBase, addrSize, portNumber);
	}
	if (!(failed())) {
		pop(1);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocket:bindTo: */
EXPORT(sqInt)
primitiveSocketBindTo(void)
{
	char *addrBase;
	sqInt addrSize;
	SocketPtr s;
	sqInt socket;
	sqInt socketAddress;

	socket = stackValue(1);
	socketAddress = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	addrSize = byteSizeOf(socketAddress);
	addrBase = ((char *) (firstIndexableField(socketAddress)));
	if (!(failed())) {
		sqSocketBindToAddressSize(s, addrBase, addrSize);
	}
	if (!(failed())) {
		pop(2);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocket:bindTo:port: */
EXPORT(sqInt)
primitiveSocketBindToPort(void)
{
	sqInt addr;
	char *address;
	sqInt port;
	SocketPtr s;
	sqInt socket;
	sqInt sz;

	if (!((isBytes(stackValue(1)))
		 && (isIntegerObject(stackValue(0))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socket = stackValue(2);
	address = ((char *) (firstIndexableField(stackValue(1))));
	port = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	/* begin netAddressToInt: */
	sz = byteSizeOf(((sqInt)(sqIntptr_t)((((unsigned char *) address))) - BaseHeaderSize));
	if (!(sz == 4)) {
		addr = primitiveFail();
		goto l1;
	}
	addr = ((((((unsigned char *) address))[3]) + (((usqInt)(((((unsigned char *) address))[2])) << 8))) + (((usqInt)(((((unsigned char *) address))[1])) << 16))) + (((usqInt)(((((unsigned char *) address))[0])) << 24));
	l1:	/* end netAddressToInt: */;
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (!(failed())) {
		sqSocketBindToPort(s, addr, port);
	}
	if (!(failed())) {
		pop(3);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketCloseConnection: */
EXPORT(sqInt)
primitiveSocketCloseConnection(void)
{
	SocketPtr s;
	sqInt socket;

	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (!(failed())) {
		sqSocketCloseConnection(s);
	}
	if (!(failed())) {
		pop(1);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketConnectionStatus: */
EXPORT(sqInt)
primitiveSocketConnectionStatus(void)
{
	SocketPtr s;
	sqInt socket;
	sqInt status;

	status = 0;
	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (!(failed())) {
		status = sqSocketConnectionStatus(s);
	}
	if (!(failed())) {
		popthenPush(2, integerObjectOf(status));
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocket:connectTo: */
EXPORT(sqInt)
primitiveSocketConnectTo(void)
{
	char *addrBase;
	sqInt addrSize;
	SocketPtr s;
	sqInt socket;
	sqInt socketAddress;

	socket = stackValue(1);
	socketAddress = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	addrSize = byteSizeOf(socketAddress);
	addrBase = ((char *) (firstIndexableField(socketAddress)));
	if (!(failed())) {
		sqSocketConnectToAddressSize(s, addrBase, addrSize);
	}
	if (!(failed())) {
		pop(2);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocket:connectTo:port: */
EXPORT(sqInt)
primitiveSocketConnectToPort(void)
{
	sqInt addr;
	char *address;
	sqInt port;
	SocketPtr s;
	sqInt socket;
	sqInt sz;

	if (!((isBytes(stackValue(1)))
		 && (isIntegerObject(stackValue(0))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socket = stackValue(2);
	address = ((char *) (firstIndexableField(stackValue(1))));
	port = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	/* begin netAddressToInt: */
	sz = byteSizeOf(((sqInt)(sqIntptr_t)((((unsigned char *) address))) - BaseHeaderSize));
	if (!(sz == 4)) {
		addr = primitiveFail();
		goto l1;
	}
	addr = ((((((unsigned char *) address))[3]) + (((usqInt)(((((unsigned char *) address))[2])) << 8))) + (((usqInt)(((((unsigned char *) address))[1])) << 16))) + (((usqInt)(((((unsigned char *) address))[0])) << 24));
	l1:	/* end netAddressToInt: */;

	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (!(failed())) {
		sqSocketConnectToPort(s, addr, port);
	}
	if (!(failed())) {
		pop(3);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketCreateNetwork:type:receiveBufferSize:sendBufSize:semaIndex: */
EXPORT(sqInt)
primitiveSocketCreate(void)
{
	sqInt netType;
	sqInt recvBufSize;
	SocketPtr s;
	sqInt semaIndex;
	sqInt sendBufSize;
	sqInt socketOop;
	sqInt socketType;

	if (!((isIntegerObject(stackValue(4)))
		 && ((isIntegerObject(stackValue(3)))
		 && ((isIntegerObject(stackValue(2)))
		 && ((isIntegerObject(stackValue(1)))
		 && (isIntegerObject(stackValue(0)))))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	netType = stackIntegerValue(4);
	socketType = stackIntegerValue(3);
	recvBufSize = stackIntegerValue(2);
	sendBufSize = stackIntegerValue(1);
	semaIndex = stackIntegerValue(0);
	if (failed()) {
		return null;
	}

	socketOop = instantiateClassindexableSize(classByteArray(), sizeof(SQSocket));
	/* begin socketValueOf: */
	if ((isBytes(socketOop))
	 && ((byteSizeOf(socketOop)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socketOop)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (!(failed())) {
		sqSocketCreateNetTypeSocketTypeRecvBytesSendBytesSemaID(s, netType, socketType, recvBufSize, sendBufSize, semaIndex);
	}
	if (!(failed())) {
		popthenPush(6, socketOop);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketCreateNetwork:type:receiveBufferSize:sendBufSize:semaIndex:readSemaIndex:writeSemaIndex: */
EXPORT(sqInt)
primitiveSocketCreate3Semaphores(void)
{
	sqInt aReadSema;
	sqInt aWriteSema;
	sqInt netType;
	sqInt recvBufSize;
	SocketPtr s;
	sqInt semaIndex;
	sqInt sendBufSize;
	sqInt socketOop;
	sqInt socketType;

	if (!((isIntegerObject(stackValue(6)))
		 && ((isIntegerObject(stackValue(5)))
		 && ((isIntegerObject(stackValue(4)))
		 && ((isIntegerObject(stackValue(3)))
		 && ((isIntegerObject(stackValue(2)))
		 && ((isIntegerObject(stackValue(1)))
		 && (isIntegerObject(stackValue(0)))))))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	netType = stackIntegerValue(6);
	socketType = stackIntegerValue(5);
	recvBufSize = stackIntegerValue(4);
	sendBufSize = stackIntegerValue(3);
	semaIndex = stackIntegerValue(2);
	aReadSema = stackIntegerValue(1);
	aWriteSema = stackIntegerValue(0);
	if (failed()) {
		return null;
	}

	socketOop = instantiateClassindexableSize(classByteArray(), sizeof(SQSocket));
	/* begin socketValueOf: */
	if ((isBytes(socketOop))
	 && ((byteSizeOf(socketOop)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socketOop)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (!(failed())) {
		sqSocketCreateNetTypeSocketTypeRecvBytesSendBytesSemaIDReadSemaIDWriteSemaID(s, netType, socketType, recvBufSize, sendBufSize, semaIndex, aReadSema, aWriteSema);
	}
	if (!(failed())) {
		popthenPush(8, socketOop);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketCreateRaw:type:receiveBufferSize:sendBufSize:semaIndex:readSemaIndex:writeSemaIndex: */
EXPORT(sqInt)
primitiveSocketCreateRAW(void)
{
	sqInt aReadSema;
	sqInt aWriteSema;
	sqInt netType;
	sqInt protoType;
	sqInt recvBufSize;
	SocketPtr s;
	sqInt semaIndex;
	sqInt sendBufSize;
	sqInt socketOop;

	if (!((isIntegerObject(stackValue(6)))
		 && ((isIntegerObject(stackValue(5)))
		 && ((isIntegerObject(stackValue(4)))
		 && ((isIntegerObject(stackValue(3)))
		 && ((isIntegerObject(stackValue(2)))
		 && ((isIntegerObject(stackValue(1)))
		 && (isIntegerObject(stackValue(0)))))))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	netType = stackIntegerValue(6);
	protoType = stackIntegerValue(5);
	recvBufSize = stackIntegerValue(4);
	sendBufSize = stackIntegerValue(3);
	semaIndex = stackIntegerValue(2);
	aReadSema = stackIntegerValue(1);
	aWriteSema = stackIntegerValue(0);
	if (failed()) {
		return null;
	}

	socketOop = instantiateClassindexableSize(classByteArray(), sizeof(SQSocket));
	/* begin socketValueOf: */
	if ((isBytes(socketOop))
	 && ((byteSizeOf(socketOop)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socketOop)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (!(failed())) {
		sqSocketCreateRawProtoTypeRecvBytesSendBytesSemaIDReadSemaIDWriteSemaID(s, netType, protoType, recvBufSize, sendBufSize, semaIndex, aReadSema, aWriteSema);
	}
	if (!(failed())) {
		popthenPush(8, socketOop);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketDestroy: */
EXPORT(sqInt)
primitiveSocketDestroy(void)
{
	SocketPtr s;
	sqInt socket;

	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (!(failed())) {
		sqSocketDestroy(s);
	}
	if (!(failed())) {
		pop(1);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketError: */
EXPORT(sqInt)
primitiveSocketError(void)
{
	sqInt err;
	SocketPtr s;
	sqInt socket;

	err = 0;
	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (!(failed())) {
		err = sqSocketError(s);
	}
	if (!(failed())) {
		popthenPush(2, integerObjectOf(err));
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocket:getOptions: */
EXPORT(sqInt)
primitiveSocketGetOptions(void)
{
	sqInt errorCode;
	sqInt optionName;
	sqInt optionNameSize;
	char *optionNameStart;
	sqInt results;
	sqInt returnedValue;
	SocketPtr s;
	sqInt socket;

	socket = stackValue(1);
	optionName = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	success(isBytes(optionName));
	optionNameStart = ((char *) (firstIndexableField(optionName)));
	optionNameSize = slotSizeOf(optionName);
	if (failed()) {
		return null;
	}
	returnedValue = 0;
	errorCode = sqSocketGetOptionsoptionNameStartoptionNameSizereturnedValue(s, optionNameStart, optionNameSize, (&returnedValue));
	results = instantiateClassindexableSize(classArray(), 2);
	storePointerofObjectwithValue(0, results, integerObjectOf(errorCode));
	storePointerofObjectwithValue(1, results, integerObjectOf(returnedValue));
	if (!(failed())) {
		popthenPush(3, results);
	}
	return null;
}


/*	one part of the wierdass dual prim primitiveSocketListenOnPort which 
	was warped by some demented evil person determined to twist the very 
	nature of reality */

	/* SocketPlugin>>#primitiveSocket:listenOnPort: */
EXPORT(sqInt)
primitiveSocketListenOnPort(void)
{
	sqInt port;
	SocketPtr s;
	sqInt socket;

	if (!(isIntegerObject(stackValue(0)))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socket = stackValue(1);
	port = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}

	if (!(failed())) {
		sqSocketListenOnPort(s, port);
	}
	if (!(failed())) {
		pop(2);
	}
	return null;
}


/*	second part of the wierdass dual prim primitiveSocketListenOnPort 
	which was warped by some demented evil person determined to twist the 
	very nature of reality */

	/* SocketPlugin>>#primitiveSocket:listenOnPort:backlogSize: */
EXPORT(sqInt)
primitiveSocketListenOnPortBacklog(void)
{
	sqInt backlog;
	sqInt port;
	SocketPtr s;
	sqInt socket;

	if (!((isIntegerObject(stackValue(1)))
		 && (isIntegerObject(stackValue(0))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socket = stackValue(2);
	port = stackIntegerValue(1);
	backlog = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}

	sqSocketListenOnPortBacklogSize(s, port, backlog);
	if (!(failed())) {
		pop(3);
	}
	return null;
}


/*	Bind a socket to the given port and interface address with no more than
	backlog pending connections. The socket can be UDP, in which case the
	backlog should be specified as zero.
 */

	/* SocketPlugin>>#primitiveSocket:listenOnPort:backlogSize:interface: */
EXPORT(sqInt)
primitiveSocketListenOnPortBacklogInterface(void)
{
	sqInt addr;
	sqInt backlog;
	char *ifAddr;
	sqInt port;
	SocketPtr s;
	sqInt socket;
	sqInt sz;

	if (!((isIntegerObject(stackValue(2)))
		 && ((isIntegerObject(stackValue(1)))
		 && (isBytes(stackValue(0)))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socket = stackValue(3);
	port = stackIntegerValue(2);
	backlog = stackIntegerValue(1);
	ifAddr = ((char *) (firstIndexableField(stackValue(0))));
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}

	/* begin netAddressToInt: */
	sz = byteSizeOf(((sqInt)(sqIntptr_t)((((unsigned char *) ifAddr))) - BaseHeaderSize));
	if (!(sz == 4)) {
		addr = primitiveFail();
		goto l1;
	}
	addr = ((((((unsigned char *) ifAddr))[3]) + (((usqInt)(((((unsigned char *) ifAddr))[2])) << 8))) + (((usqInt)(((((unsigned char *) ifAddr))[1])) << 16))) + (((usqInt)(((((unsigned char *) ifAddr))[0])) << 24));
	l1:	/* end netAddressToInt: */;
	sqSocketListenOnPortBacklogSizeInterface(s, port, backlog, addr);
	if (!(failed())) {
		pop(4);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocket:listenWithBacklog: */
EXPORT(sqInt)
primitiveSocketListenWithBacklog(void)
{
	sqInt backlogSize;
	SocketPtr s;
	sqInt socket;

	if (!(isIntegerObject(stackValue(0)))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socket = stackValue(1);
	backlogSize = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (!(failed())) {
		sqSocketListenBacklog(s, backlogSize);
	}
	if (!(failed())) {
		pop(2);
	}
	return null;
}


/*	Backward compatibility */

	/* SocketPlugin>>#primitiveSocketListenWithOrWithoutBacklog */
EXPORT(sqInt)
primitiveSocketListenWithOrWithoutBacklog(void)
{
	if ((methodArgumentCount()) == 2) {
		return primitiveSocketListenOnPort();
	}
	else {
		return primitiveSocketListenOnPortBacklog();
	}
}

	/* SocketPlugin>>#primitiveSocketLocalAddress: */
EXPORT(sqInt)
primitiveSocketLocalAddress(void)
{
	sqInt addr;
	SocketPtr s;
	sqInt socket;
	sqInt _return_value;

	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	addr = sqSocketLocalAddress(s);
	if (!(failed())) {
		_return_value = intToNetAddress(addr);
		if (!(failed())) {
			popthenPush(2, _return_value);
		}
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocket:localAddressResult: */
EXPORT(sqInt)
primitiveSocketLocalAddressResult(void)
{
	char *addrBase;
	sqInt addrSize;
	SocketPtr s;
	sqInt socket;
	sqInt socketAddress;

	socket = stackValue(1);
	socketAddress = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	addrSize = byteSizeOf(socketAddress);
	addrBase = ((char *) (firstIndexableField(socketAddress)));
	if (!(failed())) {
		sqSocketLocalAddressResultSize(s, addrBase, addrSize);
	}
	if (!(failed())) {
		pop(2);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketLocalAddressSize: */
EXPORT(sqInt)
primitiveSocketLocalAddressSize(void)
{
	SocketPtr s;
	sqInt size;
	sqInt socket;

	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (failed()) {
		return null;
	}
	size = sqSocketLocalAddressSize(s);
	if (failed()) {
		return null;
	}
	if (!(failed())) {
		popthenPush(2, integerObjectOf(size));
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketLocalPort: */
EXPORT(sqInt)
primitiveSocketLocalPort(void)
{
	sqInt port;
	SocketPtr s;
	sqInt socket;

	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	port = sqSocketLocalPort(s);
	if (!(failed())) {
		popthenPush(2, integerObjectOf(port));
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketReceiveDataAvailable: */
EXPORT(sqInt)
primitiveSocketReceiveDataAvailable(void)
{
	sqInt dataIsAvailable;
	SocketPtr s;
	sqInt socket;

	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	dataIsAvailable = sqSocketReceiveDataAvailable(s);
	if (!(failed())) {
		popthenPush(2, ((dataIsAvailable) ? trueObject() : falseObject()));
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocket:receiveDataBuf:start:count: */
EXPORT(sqInt)
primitiveSocketReceiveDataBufCount(void)
{
	sqInt array;
	char *arrayBase;
	char *bufStart;
	sqInt byteSize;
	sqInt bytesReceived;
	sqInt count;
	SocketPtr s;
	sqInt socket;
	sqInt startIndex;

	bytesReceived = 0;
	if (!((isIntegerObject(stackValue(1)))
		 && (isIntegerObject(stackValue(0))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socket = stackValue(3);
	array = stackValue(2);
	startIndex = stackIntegerValue(1);
	count = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	success(isWordsOrBytes(array));
	if (isWords(array)) {
		byteSize = 4;
	}
	else {
		byteSize = 1;
	}
	success((startIndex >= 1)
	 && ((count >= 0)
	 && (((startIndex + count) - 1) <= (slotSizeOf(array)))));
	if (!(failed())) {

		/* Note: adjust bufStart for zero-origin indexing */
		arrayBase = ((char *) (firstIndexableField(array)));
		bufStart = arrayBase + ((startIndex - 1) * byteSize);
		bytesReceived = sqSocketReceiveDataBufCount(s, bufStart, count * byteSize);
	}
	if (!(failed())) {
		popthenPush(5, integerObjectOf((bytesReceived / byteSize)));
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocket:receiveUDPDataBuf:start:count: */
EXPORT(sqInt)
primitiveSocketReceiveUDPDataBufCount(void)
{
	sqInt address;
	sqInt array;
	char *arrayBase;
	char *bufStart;
	sqInt bytesReceived;
	sqInt count;
	sqInt elementSize;
	sqInt moreFlag;
	sqInt port;
	sqInt results;
	SocketPtr s;
	sqInt socket;
	sqInt startIndex;

	results = 0;
	if (!((isIntegerObject(stackValue(1)))
		 && (isIntegerObject(stackValue(0))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socket = stackValue(3);
	array = stackValue(2);
	startIndex = stackIntegerValue(1);
	count = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	success(isWordsOrBytes(array));
	if (isWords(array)) {
		elementSize = 4;
	}
	else {
		elementSize = 1;
	}
	success((startIndex >= 1)
	 && ((count >= 0)
	 && (((startIndex + count) - 1) <= (slotSizeOf(array)))));
	if (!(failed())) {

		/* Note: adjust bufStart for zero-origin indexing */
		arrayBase = ((char *) (firstIndexableField(array)));
		bufStart = arrayBase + ((startIndex - 1) * elementSize);
		address = 0;
		port = 0;
		moreFlag = 0;

		/* allocate storage for results, remapping newly allocated
		   oops in case GC happens during allocation */
		bytesReceived = sqSocketReceiveUDPDataBufCountaddressportmoreFlag(s, bufStart, count * elementSize, (&address), (&port), (&moreFlag));
		pushRemappableOop(intToNetAddress(address));
		results = instantiateClassindexableSize(classArray(), 4);
		storePointerofObjectwithValue(0, results, integerObjectOf((bytesReceived / elementSize)));
		storePointerofObjectwithValue(1, results, popRemappableOop());
		storePointerofObjectwithValue(2, results, integerObjectOf(port));
		storePointerofObjectwithValue(3, results, (moreFlag
			? trueObject()
			: falseObject()));
	}
	if (!(failed())) {
		popthenPush(5, results);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketRemoteAddress: */
EXPORT(sqInt)
primitiveSocketRemoteAddress(void)
{
	sqInt addr;
	SocketPtr s;
	sqInt socket;
	sqInt _return_value;

	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	addr = sqSocketRemoteAddress(s);
	if (!(failed())) {
		_return_value = intToNetAddress(addr);
		if (!(failed())) {
			popthenPush(2, _return_value);
		}
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocket:remoteAddressResult: */
EXPORT(sqInt)
primitiveSocketRemoteAddressResult(void)
{
	char *addrBase;
	sqInt addrSize;
	SocketPtr s;
	sqInt socket;
	sqInt socketAddress;

	socket = stackValue(1);
	socketAddress = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	addrSize = byteSizeOf(socketAddress);
	addrBase = ((char *) (firstIndexableField(socketAddress)));
	if (!(failed())) {
		sqSocketRemoteAddressResultSize(s, addrBase, addrSize);
	}
	if (!(failed())) {
		pop(2);
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketRemoteAddressSize: */
EXPORT(sqInt)
primitiveSocketRemoteAddressSize(void)
{
	SocketPtr s;
	sqInt size;
	sqInt socket;

	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	if (failed()) {
		return null;
	}
	size = sqSocketRemoteAddressSize(s);
	if (failed()) {
		return null;
	}
	if (!(failed())) {
		popthenPush(2, integerObjectOf(size));
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketRemotePort: */
EXPORT(sqInt)
primitiveSocketRemotePort(void)
{
	sqInt port;
	SocketPtr s;
	sqInt socket;

	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	port = sqSocketRemotePort(s);
	if (!(failed())) {
		popthenPush(2, integerObjectOf(port));
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocket:sendData:start:count: */
EXPORT(sqInt)
primitiveSocketSendDataBufCount(void)
{
	sqInt array;
	char *arrayBase;
	char *bufStart;
	sqInt byteSize;
	sqInt bytesSent;
	sqInt count;
	SocketPtr s;
	sqInt socket;
	sqInt startIndex;

	bytesSent = 0;
	if (!((isIntegerObject(stackValue(1)))
		 && (isIntegerObject(stackValue(0))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socket = stackValue(3);
	array = stackValue(2);
	startIndex = stackIntegerValue(1);
	count = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	success(isWordsOrBytes(array));
	if (isWords(array)) {
		byteSize = 4;
	}
	else {
		byteSize = 1;
	}
	success((startIndex >= 1)
	 && ((count >= 0)
	 && (((startIndex + count) - 1) <= (slotSizeOf(array)))));
	if (!(failed())) {

		/* Note: adjust bufStart for zero-origin indexing */
		arrayBase = ((char *) (firstIndexableField(array)));
		bufStart = arrayBase + ((startIndex - 1) * byteSize);
		bytesSent = sqSocketSendDataBufCount(s, bufStart, count * byteSize);
	}
	if (!(failed())) {
		popthenPush(5, integerObjectOf((bytesSent / byteSize)));
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocketSendDone: */
EXPORT(sqInt)
primitiveSocketSendDone(void)
{
	sqInt done;
	SocketPtr s;
	sqInt socket;

	socket = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	done = sqSocketSendDone(s);
	if (!(failed())) {
		popthenPush(2, ((done) ? trueObject() : falseObject()));
	}
	return null;
}

	/* SocketPlugin>>#primitiveSocket:sendUDPData:toHost:port:start:count: */
EXPORT(sqInt)
primitiveSocketSendUDPDataBufCount(void)
{
	sqInt address;
	sqInt array;
	char *arrayBase;
	char *bufStart;
	sqInt byteSize;
	sqInt bytesSent;
	sqInt count;
	char *hostAddress;
	sqInt portNumber;
	SocketPtr s;
	sqInt socket;
	sqInt startIndex;
	sqInt sz;

	bytesSent = 0;
	if (!((isBytes(stackValue(3)))
		 && ((isIntegerObject(stackValue(2)))
		 && ((isIntegerObject(stackValue(1)))
		 && (isIntegerObject(stackValue(0))))))) {
		primitiveFailFor(PrimErrBadArgument);
		return null;
	}
	socket = stackValue(5);
	array = stackValue(4);
	hostAddress = ((char *) (firstIndexableField(stackValue(3))));
	portNumber = stackIntegerValue(2);
	startIndex = stackIntegerValue(1);
	count = stackIntegerValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	success(isWordsOrBytes(array));
	if (isWords(array)) {
		byteSize = 4;
	}
	else {
		byteSize = 1;
	}
	success((startIndex >= 1)
	 && ((count >= 0)
	 && (((startIndex + count) - 1) <= (slotSizeOf(array)))));
	if (!(failed())) {

		/* Note: adjust bufStart for zero-origin indexing */
		arrayBase = ((char *) (firstIndexableField(array)));
		bufStart = arrayBase + ((startIndex - 1) * byteSize);
		/* begin netAddressToInt: */
		sz = byteSizeOf(((sqInt)(sqIntptr_t)((((unsigned char *) hostAddress))) - BaseHeaderSize));
		if (!(sz == 4)) {
			address = primitiveFail();
			goto l1;
		}
		address = ((((((unsigned char *) hostAddress))[3]) + (((usqInt)(((((unsigned char *) hostAddress))[2])) << 8))) + (((usqInt)(((((unsigned char *) hostAddress))[1])) << 16))) + (((usqInt)(((((unsigned char *) hostAddress))[0])) << 24));
	l1:	/* end netAddressToInt: */;
		bytesSent = sqSockettoHostportSendDataBufCount(s, address, portNumber, bufStart, count * byteSize);
	}
	if (!(failed())) {
		popthenPush(7, integerObjectOf((bytesSent / byteSize)));
	}
	return null;
}


/*	THIS BADLY NEEDS TO BE REWRITTEN TO TAKE Booleans AND Integers AS WELL AS
	(OR INSTEAD OF) Strings.
	It is only used with booleans and integers and parsing these back out of
	strings in

	sqSocketSetOptions:optionNameStart:optionNameSize:optionValueStart:optionValueSize:returnedValue:
	is STUPID. */

	/* SocketPlugin>>#primitiveSocket:setOptions:value: */
EXPORT(sqInt)
primitiveSocketSetOptions(void)
{
	sqInt errorCode;
	sqInt optionName;
	sqInt optionNameSize;
	char *optionNameStart;
	sqInt optionValue;
	sqInt optionValueSize;
	char *optionValueStart;
	sqInt results;
	sqInt returnedValue;
	SocketPtr s;
	sqInt socket;

	socket = stackValue(2);
	optionName = stackValue(1);
	optionValue = stackValue(0);
	if (failed()) {
		return null;
	}
	/* begin socketValueOf: */
	if ((isBytes(socket))
	 && ((byteSizeOf(socket)) == (sizeof(SQSocket)))) {
		s = ((SocketPtr) (firstIndexableField(socket)));
	}
	else {
		primitiveFailFor(PrimErrBadArgument);
		s = null;
	}
	success(isBytes(optionName));
	optionNameStart = ((char *) (firstIndexableField(optionName)));
	optionNameSize = slotSizeOf(optionName);
	success(isBytes(optionValue));
	optionValueStart = ((char *) (firstIndexableField(optionValue)));
	optionValueSize = slotSizeOf(optionValue);
	if (failed()) {
		return null;
	}
	returnedValue = 0;
	errorCode = sqSocketSetOptionsoptionNameStartoptionNameSizeoptionValueStartoptionValueSizereturnedValue(s, optionNameStart, optionNameSize, optionValueStart, optionValueSize, (&returnedValue));
	results = instantiateClassindexableSize(classArray(), 2);
	storePointerofObjectwithValue(0, results, integerObjectOf(errorCode));
	storePointerofObjectwithValue(1, results, integerObjectOf(returnedValue));
	if (!(failed())) {
		popthenPush(4, results);
	}
	return null;
}


/*	Note: This is coded so that it can be run in Squeak. */

	/* InterpreterPlugin>>#setInterpreter: */
EXPORT(sqInt)
setInterpreter(struct VirtualMachine *anInterpreter)
{
	sqInt ok;

	interpreterProxy = anInterpreter;
	ok = ((interpreterProxy->majorVersion()) == (VM_PROXY_MAJOR))
	 && ((interpreterProxy->minorVersion()) >= (VM_PROXY_MINOR));
	if (ok) {
		
#if !defined(SQUEAK_BUILTIN_PLUGIN)
		byteSizeOf = interpreterProxy->byteSizeOf;
		classArray = interpreterProxy->classArray;
		classByteArray = interpreterProxy->classByteArray;
		classString = interpreterProxy->classString;
		failed = interpreterProxy->failed;
		falseObject = interpreterProxy->falseObject;
		firstIndexableField = interpreterProxy->firstIndexableField;
		instantiateClassindexableSize = interpreterProxy->instantiateClassindexableSize;
		integerObjectOf = interpreterProxy->integerObjectOf;
		ioLoadFunctionFrom = interpreterProxy->ioLoadFunctionFrom;
		isBytes = interpreterProxy->isBytes;
		isIntegerObject = interpreterProxy->isIntegerObject;
		isWords = interpreterProxy->isWords;
		isWordsOrBytes = interpreterProxy->isWordsOrBytes;
		methodArgumentCount = interpreterProxy->methodArgumentCount;
		pop = interpreterProxy->pop;
		popthenPush = interpreterProxy->popthenPush;
		popRemappableOop = interpreterProxy->popRemappableOop;
		primitiveFail = interpreterProxy->primitiveFail;
		primitiveFailFor = interpreterProxy->primitiveFailFor;
		pushRemappableOop = interpreterProxy->pushRemappableOop;
		slotSizeOf = interpreterProxy->slotSizeOf;
		stackIntegerValue = interpreterProxy->stackIntegerValue;
		stackValue = interpreterProxy->stackValue;
		storePointerofObjectwithValue = interpreterProxy->storePointerofObjectwithValue;
		success = interpreterProxy->success;
		trueObject = interpreterProxy->trueObject;
#endif /* !defined(SQUEAK_BUILTIN_PLUGIN) */
	}
	return ok;
}

	/* SocketPlugin>>#shutdownModule */
EXPORT(sqInt)
shutdownModule(void)
{
	return socketShutdown();
}


/*	Return the size of a Smalltalk socket record in bytes. */

	/* SocketPlugin>>#socketRecordSize */
static sqInt
socketRecordSize(void)
{
	return sizeof(SQSocket);
}


/*	Answer a pointer to the first byte of of the socket record within the 
	given Smalltalk object, or nil if socketOop is not a socket record. */

	/* SocketPlugin>>#socketValueOf: */
static SocketPtr
socketValueOf(sqInt socketOop)
{
	if ((isBytes(socketOop)) && ((byteSizeOf(socketOop)) == (sizeof(SQSocket)))) {
		return (SocketPtr) (firstIndexableField(socketOop));
	}
	primitiveFailFor(PrimErrBadArgument);
	return null;
}

	/* SmartSyntaxInterpreterPlugin>>#sqAssert: */
static sqInt
sqAssert(sqInt aBool)
{
	/* missing DebugCode */;
	return aBool;
}


#ifdef SQUEAK_BUILTIN_PLUGIN

static char _m[] = "SocketPlugin";
void* SocketPlugin_exports[][3] = {
	{(void*)_m, "getModuleName", (void*)getModuleName},
	{(void*)_m, "initialiseModule", (void*)initialiseModule},
	{(void*)_m, "moduleUnloaded", (void*)moduleUnloaded},
	{(void*)_m, "primitiveInitializeNetwork\000\000", (void*)primitiveInitializeNetwork},
	{(void*)_m, "primitiveResolverAbortLookup\000\377", (void*)primitiveResolverAbortLookup},
	{(void*)_m, "primitiveResolverAddressLookupResult\000\377", (void*)primitiveResolverAddressLookupResult},
	{(void*)_m, "primitiveResolverError\000\377", (void*)primitiveResolverError},
	{(void*)_m, "primitiveResolverGetAddressInfo\000\000", (void*)primitiveResolverGetAddressInfo},
	{(void*)_m, "primitiveResolverGetAddressInfoFamily\000\377", (void*)primitiveResolverGetAddressInfoFamily},
	{(void*)_m, "primitiveResolverGetAddressInfoNext\000\377", (void*)primitiveResolverGetAddressInfoNext},
	{(void*)_m, "primitiveResolverGetAddressInfoProtocol\000\377", (void*)primitiveResolverGetAddressInfoProtocol},
	{(void*)_m, "primitiveResolverGetAddressInfoResult\000\377", (void*)primitiveResolverGetAddressInfoResult},
	{(void*)_m, "primitiveResolverGetAddressInfoSize\000\377", (void*)primitiveResolverGetAddressInfoSize},
	{(void*)_m, "primitiveResolverGetAddressInfoType\000\377", (void*)primitiveResolverGetAddressInfoType},
	{(void*)_m, "primitiveResolverGetNameInfo\000\000", (void*)primitiveResolverGetNameInfo},
	{(void*)_m, "primitiveResolverGetNameInfoHostResult\000\377", (void*)primitiveResolverGetNameInfoHostResult},
	{(void*)_m, "primitiveResolverGetNameInfoHostSize\000\377", (void*)primitiveResolverGetNameInfoHostSize},
	{(void*)_m, "primitiveResolverGetNameInfoServiceResult\000\377", (void*)primitiveResolverGetNameInfoServiceResult},
	{(void*)_m, "primitiveResolverGetNameInfoServiceSize\000\377", (void*)primitiveResolverGetNameInfoServiceSize},
	{(void*)_m, "primitiveResolverHostNameResult\000\377", (void*)primitiveResolverHostNameResult},
	{(void*)_m, "primitiveResolverHostNameSize\000\377", (void*)primitiveResolverHostNameSize},
	{(void*)_m, "primitiveResolverLocalAddress\000\377", (void*)primitiveResolverLocalAddress},
	{(void*)_m, "primitiveResolverNameLookupResult\000\377", (void*)primitiveResolverNameLookupResult},
	{(void*)_m, "primitiveResolverStartAddressLookup\000\377", (void*)primitiveResolverStartAddressLookup},
	{(void*)_m, "primitiveResolverStartNameLookup\000\377", (void*)primitiveResolverStartNameLookup},
	{(void*)_m, "primitiveResolverStatus\000\377", (void*)primitiveResolverStatus},
	{(void*)_m, "primitiveSocketAbortConnection\000\000", (void*)primitiveSocketAbortConnection},
	{(void*)_m, "primitiveSocketAccept\000\000", (void*)primitiveSocketAccept},
	{(void*)_m, "primitiveSocketAccept3Semaphores\000\000", (void*)primitiveSocketAccept3Semaphores},
	{(void*)_m, "primitiveSocketAddressGetPort\000\000", (void*)primitiveSocketAddressGetPort},
	{(void*)_m, "primitiveSocketAddressSetPort\000\000", (void*)primitiveSocketAddressSetPort},
	{(void*)_m, "primitiveSocketBindTo\000\000", (void*)primitiveSocketBindTo},
	{(void*)_m, "primitiveSocketBindToPort\000\000", (void*)primitiveSocketBindToPort},
	{(void*)_m, "primitiveSocketCloseConnection\000\000", (void*)primitiveSocketCloseConnection},
	{(void*)_m, "primitiveSocketConnectionStatus\000\000", (void*)primitiveSocketConnectionStatus},
	{(void*)_m, "primitiveSocketConnectTo\000\000", (void*)primitiveSocketConnectTo},
	{(void*)_m, "primitiveSocketConnectToPort\000\000", (void*)primitiveSocketConnectToPort},
	{(void*)_m, "primitiveSocketCreate\000\000", (void*)primitiveSocketCreate},
	{(void*)_m, "primitiveSocketCreate3Semaphores\000\000", (void*)primitiveSocketCreate3Semaphores},
	{(void*)_m, "primitiveSocketCreateRAW\000\000", (void*)primitiveSocketCreateRAW},
	{(void*)_m, "primitiveSocketDestroy\000\000", (void*)primitiveSocketDestroy},
	{(void*)_m, "primitiveSocketError\000\000", (void*)primitiveSocketError},
	{(void*)_m, "primitiveSocketGetOptions\000\000", (void*)primitiveSocketGetOptions},
	{(void*)_m, "primitiveSocketListenOnPort\000\000", (void*)primitiveSocketListenOnPort},
	{(void*)_m, "primitiveSocketListenOnPortBacklog\000\000", (void*)primitiveSocketListenOnPortBacklog},
	{(void*)_m, "primitiveSocketListenOnPortBacklogInterface\000\000", (void*)primitiveSocketListenOnPortBacklogInterface},
	{(void*)_m, "primitiveSocketListenWithBacklog\000\000", (void*)primitiveSocketListenWithBacklog},
	{(void*)_m, "primitiveSocketListenWithOrWithoutBacklog\000\000", (void*)primitiveSocketListenWithOrWithoutBacklog},
	{(void*)_m, "primitiveSocketLocalAddress\000\000", (void*)primitiveSocketLocalAddress},
	{(void*)_m, "primitiveSocketLocalAddressResult\000\000", (void*)primitiveSocketLocalAddressResult},
	{(void*)_m, "primitiveSocketLocalAddressSize\000\000", (void*)primitiveSocketLocalAddressSize},
	{(void*)_m, "primitiveSocketLocalPort\000\000", (void*)primitiveSocketLocalPort},
	{(void*)_m, "primitiveSocketReceiveDataAvailable\000\000", (void*)primitiveSocketReceiveDataAvailable},
	{(void*)_m, "primitiveSocketReceiveDataBufCount\000\000", (void*)primitiveSocketReceiveDataBufCount},
	{(void*)_m, "primitiveSocketReceiveUDPDataBufCount\000\000", (void*)primitiveSocketReceiveUDPDataBufCount},
	{(void*)_m, "primitiveSocketRemoteAddress\000\000", (void*)primitiveSocketRemoteAddress},
	{(void*)_m, "primitiveSocketRemoteAddressResult\000\000", (void*)primitiveSocketRemoteAddressResult},
	{(void*)_m, "primitiveSocketRemoteAddressSize\000\000", (void*)primitiveSocketRemoteAddressSize},
	{(void*)_m, "primitiveSocketRemotePort\000\000", (void*)primitiveSocketRemotePort},
	{(void*)_m, "primitiveSocketSendDataBufCount\000\000", (void*)primitiveSocketSendDataBufCount},
	{(void*)_m, "primitiveSocketSendDone\000\000", (void*)primitiveSocketSendDone},
	{(void*)_m, "primitiveSocketSendUDPDataBufCount\000\000", (void*)primitiveSocketSendUDPDataBufCount},
	{(void*)_m, "primitiveSocketSetOptions\000\000", (void*)primitiveSocketSetOptions},
	{(void*)_m, "setInterpreter", (void*)setInterpreter},
	{(void*)_m, "shutdownModule\000\377", (void*)shutdownModule},
	{NULL, NULL, NULL}
};

#else /* ifdef SQ_BUILTIN_PLUGIN */

EXPORT(signed char) primitiveInitializeNetworkAccessorDepth = 0;
EXPORT(signed char) primitiveResolverGetAddressInfoAccessorDepth = 0;
EXPORT(signed char) primitiveResolverGetNameInfoAccessorDepth = 0;
EXPORT(signed char) primitiveSocketAbortConnectionAccessorDepth = 0;
EXPORT(signed char) primitiveSocketAcceptAccessorDepth = 0;
EXPORT(signed char) primitiveSocketAccept3SemaphoresAccessorDepth = 0;
EXPORT(signed char) primitiveSocketAddressGetPortAccessorDepth = 0;
EXPORT(signed char) primitiveSocketAddressSetPortAccessorDepth = 0;
EXPORT(signed char) primitiveSocketBindToAccessorDepth = 0;
EXPORT(signed char) primitiveSocketBindToPortAccessorDepth = 0;
EXPORT(signed char) primitiveSocketCloseConnectionAccessorDepth = 0;
EXPORT(signed char) primitiveSocketConnectionStatusAccessorDepth = 0;
EXPORT(signed char) primitiveSocketConnectToAccessorDepth = 0;
EXPORT(signed char) primitiveSocketConnectToPortAccessorDepth = 0;
EXPORT(signed char) primitiveSocketCreateAccessorDepth = 0;
EXPORT(signed char) primitiveSocketCreate3SemaphoresAccessorDepth = 0;
EXPORT(signed char) primitiveSocketCreateRAWAccessorDepth = 0;
EXPORT(signed char) primitiveSocketDestroyAccessorDepth = 0;
EXPORT(signed char) primitiveSocketErrorAccessorDepth = 0;
EXPORT(signed char) primitiveSocketGetOptionsAccessorDepth = 0;
EXPORT(signed char) primitiveSocketListenOnPortAccessorDepth = 0;
EXPORT(signed char) primitiveSocketListenOnPortBacklogAccessorDepth = 0;
EXPORT(signed char) primitiveSocketListenOnPortBacklogInterfaceAccessorDepth = 0;
EXPORT(signed char) primitiveSocketListenWithBacklogAccessorDepth = 0;
EXPORT(signed char) primitiveSocketListenWithOrWithoutBacklogAccessorDepth = 0;
EXPORT(signed char) primitiveSocketLocalAddressAccessorDepth = 0;
EXPORT(signed char) primitiveSocketLocalAddressResultAccessorDepth = 0;
EXPORT(signed char) primitiveSocketLocalAddressSizeAccessorDepth = 0;
EXPORT(signed char) primitiveSocketLocalPortAccessorDepth = 0;
EXPORT(signed char) primitiveSocketReceiveDataAvailableAccessorDepth = 0;
EXPORT(signed char) primitiveSocketReceiveDataBufCountAccessorDepth = 0;
EXPORT(signed char) primitiveSocketReceiveUDPDataBufCountAccessorDepth = 0;
EXPORT(signed char) primitiveSocketRemoteAddressAccessorDepth = 0;
EXPORT(signed char) primitiveSocketRemoteAddressResultAccessorDepth = 0;
EXPORT(signed char) primitiveSocketRemoteAddressSizeAccessorDepth = 0;
EXPORT(signed char) primitiveSocketRemotePortAccessorDepth = 0;
EXPORT(signed char) primitiveSocketSendDataBufCountAccessorDepth = 0;
EXPORT(signed char) primitiveSocketSendDoneAccessorDepth = 0;
EXPORT(signed char) primitiveSocketSendUDPDataBufCountAccessorDepth = 0;
EXPORT(signed char) primitiveSocketSetOptionsAccessorDepth = 0;

#endif /* ifdef SQ_BUILTIN_PLUGIN */
