/* Automatically generated by
	VMPluginCodeGenerator Melchor-tonel.1 uuid: 08095e25-d001-0e00-9989-8f9909ca3285
   from
	FilePlugin VMMaker-tonel.1 uuid: b254b225-d001-0e00-998e-8d8109ca3285
 */
static char __buildInfo[] = "FilePlugin VMMaker-tonel.1 uuid: b254b225-d001-0e00-998e-8d8109ca3285 " __DATE__ ;



#include "config.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

/* Default EXPORT macro that does nothing (see comment in sq.h): */
#define EXPORT(returnType) returnType

/* Do not include the entire sq.h file but just those parts needed. */
#include "sqConfig.h"			/* Configuration options */
#include "virtualMachine.h"	/*  The virtual machine proxy definition */
#include "sqPlatformSpecific.h"	/* Platform specific definitions */

#define true 1
#define false 0
#define null 0  /* using 'null' because nil is predefined in Think C */
#ifdef SQUEAK_BUILTIN_PLUGIN
# undef EXPORT
# define EXPORT(returnType) static returnType
#endif

#include "pharovm/imageAccess.h"
#include "FilePlugin.h"
#include "memoryAccess.h"


/*** Constants ***/
#define DirBadPath 2
#define DirNoMoreEntries 1
#define PrimErrBadArgument 3
#define PrimErrBadIndex 4
#define PrimErrInappropriate 6
#define PrimErrNoMemory 9


/*** Function Prototypes ***/
static sqInt connectToFdwrite(int _fd, sqInt _writeFlag);
static sqInt connectToFilewrite(void *_cfile, sqInt _writeFlag);
EXPORT(sqInt) fileOpenNamesizewrite(char *nameIndex, sqInt nameSize, sqInt writeFlag);
EXPORT(sqInt) fileOpenNewNamesize(char *nameIndex, sqInt nameSize);
extern usqIntptr_t fileRecordSize(void);
extern SQFile * fileValueOf(sqInt _objectPointer);
EXPORT(const char*) getModuleName(void);
EXPORT(sqInt) initialiseModule(void);
static sqInt makeDirEntryNamesizecreateDatemodDateisDirfileSize(char *_entryName, sqInt _entryNameSize, sqInt _createDate, sqInt _modifiedDate, sqInt _dirFlag, fileOffset_t _fileSize);
static sqInt makeDirEntryNamesizecreateDatemodDateisDirfileSizeposixPermissionsisSymlink(char *_entryName, sqInt _entryNameSize, sqInt _createDate, sqInt _modifiedDate, sqInt _dirFlag, fileOffset_t _fileSize, sqInt _posixPermissions, sqInt _symlinkFlag);
static void * pointerFrom(sqInt _pointerByteArray);
EXPORT(sqInt) primitiveConnectToFile(void);
EXPORT(sqInt) primitiveConnectToFileDescriptor(void);
EXPORT(sqInt) primitiveDirectoryCreate(void);
EXPORT(sqInt) primitiveDirectoryDelete(void);
EXPORT(sqInt) primitiveDirectoryDelimitor(void);
EXPORT(sqInt) primitiveDirectoryEntry(void);
EXPORT(sqInt) primitiveDirectoryGetMacTypeAndCreator(void);
EXPORT(sqInt) primitiveDirectoryLookup(void);
EXPORT(sqInt) primitiveDirectorySetMacTypeAndCreator(void);
EXPORT(sqInt) primitiveFileAtEnd(void);
EXPORT(sqInt) primitiveFileClose(void);
EXPORT(sqInt) primitiveFileDelete(void);
EXPORT(sqInt) primitiveFileDescriptorType(void);
EXPORT(sqInt) primitiveFileFlush(void);
EXPORT(sqInt) primitiveFileGetPosition(void);
EXPORT(sqInt) primitiveFileOpen(void);
EXPORT(sqInt) primitiveFileOpenNew(void);
EXPORT(sqInt) primitiveFileRead(void);
EXPORT(sqInt) primitiveFileRename(void);
EXPORT(sqInt) primitiveFileSetPosition(void);
EXPORT(sqInt) primitiveFileSize(void);
EXPORT(sqInt) primitiveFileStdioHandles(void);
EXPORT(sqInt) primitiveFileSync(void);
EXPORT(sqInt) primitiveFileTruncate(void);
EXPORT(sqInt) primitiveFileWrite(void);
EXPORT(sqInt) primitiveWaitForDataWithSemaphore(void);
EXPORT(sqInt) setInterpreter(struct VirtualMachine *_anInterpreter);
EXPORT(sqInt) setMacFileTypeAndCreator(char *fileName, char *typeString, char *creatorString);
EXPORT(sqInt) shutdownModule(void);


/*** Variables ***/

#if !defined(SQUEAK_BUILTIN_PLUGIN)
static void * (*arrayValueOf)(sqInt oop);
static sqInt (*booleanValueOf)(sqInt obj);
static sqInt (*byteSizeOf)(sqInt oop);
static sqInt (*characterObjectOf)(sqInt characterCode);
static sqInt (*classArray)(void);
static sqInt (*classByteArray)(void);
static sqInt (*classString)(void);
static sqInt (*failed)(void);
static sqInt (*falseObject)(void);
static void * (*firstIndexableField)(sqInt oop);
static sqInt (*instantiateClassindexableSize)(sqInt classPointer, sqInt size);
static sqInt (*integerObjectOf)(sqInt value);
static sqInt (*integerValueOf)(sqInt oop);
static sqInt (*isKindOf)(sqInt oop, char *aString);
static sqInt (*isBytes)(sqInt oop);
static sqInt (*isIntegerObject)(sqInt objectPointer);
static sqInt (*isWordsOrBytes)(sqInt oop);
static sqInt (*methodReturnBool)(sqInt boolean);
static sqInt (*methodReturnInteger)(sqInt integer);
static sqInt (*methodReturnValue)(sqInt oop);
static sqInt (*nilObject)(void);
static sqInt (*pop)(sqInt nItems);
static void (*popthenPush)(sqInt nItems, sqInt oop);
static sqInt (*popRemappableOop)(void);
static sqInt (*positive32BitIntegerFor)(unsigned int integerValue);
static sqInt (*positive64BitIntegerFor)(usqLong integerValue);
static usqLong (*positive64BitValueOf)(sqInt oop);
static usqIntptr_t (*positiveMachineIntegerValueOf)(sqInt oop);
static sqInt (*primitiveFail)(void);
static sqInt (*primitiveFailFor)(sqInt reasonCode);
static sqInt (*primitiveFailForOSError)(sqLong osError);
static void (*pushRemappableOop)(sqInt oop);
static sqInt (*slotSizeOf)(sqInt oop);
static sqInt (*stSizeOf)(sqInt oop);
static sqInt (*stackIntegerValue)(sqInt offset);
static sqInt (*stackValue)(sqInt offset);
static sqInt (*storePointerofObjectwithValue)(sqInt index, sqInt oop, sqInt valuePointer);
static sqInt (*topRemappableOop)(void);
static sqInt (*trueObject)(void);
#else /* !defined(SQUEAK_BUILTIN_PLUGIN) */
extern void * arrayValueOf(sqInt oop);
extern sqInt booleanValueOf(sqInt obj);
extern sqInt byteSizeOf(sqInt oop);
#if VM_PROXY_MAJOR > 1 || (VM_PROXY_MAJOR == 1 && VM_PROXY_MINOR >= 13)
extern sqInt characterObjectOf(sqInt characterCode);
#else
# define characterObjectOf(characterCode) 0
#endif
extern sqInt classArray(void);
extern sqInt classByteArray(void);
extern sqInt classString(void);
extern sqInt failed(void);
extern sqInt falseObject(void);
extern void * firstIndexableField(sqInt oop);
extern sqInt instantiateClassindexableSize(sqInt classPointer, sqInt size);
extern sqInt integerObjectOf(sqInt value);
extern sqInt integerValueOf(sqInt oop);
extern sqInt isKindOf(sqInt oop, char *aString);
extern sqInt isBytes(sqInt oop);
#if !defined(isIntegerObject)
extern sqInt isIntegerObject(sqInt objectPointer);
#endif /* !defined(isIntegerObject) */
extern sqInt isWordsOrBytes(sqInt oop);
extern sqInt methodReturnBool(sqInt boolean);
extern sqInt methodReturnInteger(sqInt integer);
extern sqInt methodReturnValue(sqInt oop);
extern sqInt nilObject(void);
extern sqInt pop(sqInt nItems);
extern void popthenPush(sqInt nItems, sqInt oop);
extern sqInt popRemappableOop(void);
extern sqInt positive32BitIntegerFor(unsigned int integerValue);
extern sqInt positive64BitIntegerFor(usqLong integerValue);
extern usqLong positive64BitValueOf(sqInt oop);
extern usqIntptr_t positiveMachineIntegerValueOf(sqInt oop);
extern sqInt primitiveFail(void);
extern sqInt primitiveFailFor(sqInt reasonCode);
#if VM_PROXY_MAJOR > 1 || (VM_PROXY_MAJOR == 1 && VM_PROXY_MINOR >= 14)
extern sqInt primitiveFailForOSError(sqLong osError);
#else
# define primitiveFailForOSError(osError) 0
#endif
extern void pushRemappableOop(sqInt oop);
extern sqInt slotSizeOf(sqInt oop);
extern sqInt stSizeOf(sqInt oop);
extern sqInt stackIntegerValue(sqInt offset);
extern sqInt stackValue(sqInt offset);
extern sqInt storePointerofObjectwithValue(sqInt index, sqInt oop, sqInt valuePointer);
extern sqInt topRemappableOop(void);
extern sqInt trueObject(void);
extern
#endif
struct VirtualMachine* interpreterProxy;
static const char *moduleName =
#ifdef SQUEAK_BUILTIN_PLUGIN
	"FilePlugin VMMaker-tonel.1 (i)"
#else
	"FilePlugin VMMaker-tonel.1 (e)"
#endif
;

/*	Connect to the supplied file descriptor. Answer the file oop. 
	On POSIX platforms this translates to fdopen(). 
	writeFlag must be compatible with the existing file access. */
/* FilePlugin>>#connectToFd:write: */
static sqInt
connectToFdwrite(int _fd, sqInt _writeFlag)
{
	SQFile *_file;
	sqInt _fileOop;

	_fileOop = instantiateClassindexableSize(classByteArray(), sizeof(SQFile));
	/* begin fileValueOf: */
	if (!((isBytes(_fileOop)) && ((byteSizeOf(_fileOop)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_fileOop);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		sqConnectToFileDescriptor(_file, _fd, _writeFlag);
	}
	return _fileOop;
}
/*	Open the FILE* as file. Answer the file oop. 
	writeFlag must be compatible with the existing file access. */
/* FilePlugin>>#connectToFile:write: */
static sqInt
connectToFilewrite(void *_cfile, sqInt _writeFlag)
{
	SQFile *_file;
	sqInt _fileOop;

	_fileOop = instantiateClassindexableSize(classByteArray(), sizeof(SQFile));
	/* begin fileValueOf: */
	if (!((isBytes(_fileOop)) && ((byteSizeOf(_fileOop)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_fileOop);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		sqConnectToFile(_file, _cfile, _writeFlag);
	}
	return _fileOop;
}
/*	Open the named file. Answer the file oop. */
/* FilePlugin>>#fileOpenName:size:write: */
EXPORT(sqInt)
fileOpenNamesizewrite(char *nameIndex, sqInt nameSize, sqInt writeFlag)
{
	SQFile *_file;
	sqInt _fileOop;

	_fileOop = instantiateClassindexableSize(classByteArray(), sizeof(SQFile));
	/* begin fileValueOf: */
	if (!((isBytes(_fileOop)) && ((byteSizeOf(_fileOop)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_fileOop);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		sqFileOpen(_file, nameIndex, nameSize, writeFlag);
	}
	return _fileOop;
}
/*	Open the new named file, possibly checking security. Answer the file oop. */
/* FilePlugin>>#fileOpenNewName:size: */
EXPORT(sqInt)
fileOpenNewNamesize(char *nameIndex, sqInt nameSize)
{
	int _exists;
	SQFile *_file;
	sqInt _fileOop;

	_fileOop = instantiateClassindexableSize(classByteArray(), sizeof(SQFile));
	/* begin fileValueOf: */
	if (!((isBytes(_fileOop)) && ((byteSizeOf(_fileOop)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_fileOop);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		_exists = 0;
		sqFileOpenNew(_file, nameIndex, nameSize, &_exists);
		if ((failed()) && _exists) {
			primitiveFailFor(PrimErrInappropriate);
		}
	}
	return _fileOop;
}
/*	Return the size of a Smalltalk file record in bytes. */
/* FilePlugin>>#fileRecordSize */
usqIntptr_t
fileRecordSize(void)
{
	return sizeof(SQFile);
}
/*	Return a pointer to the first byte of of the file record within the given 
	Smalltalk object, or nil if objectPointer is not a file record. */
/* FilePlugin>>#fileValueOf: */
SQFile *
fileValueOf(sqInt _objectPointer)
{
	if (!((isBytes(_objectPointer)) && ((byteSizeOf(_objectPointer)) == (sizeof(SQFile))))) {
		primitiveFail();
		return null;
	}
	return firstIndexableField(_objectPointer);
}
/*	Note: This is hardcoded so it can be run from Squeak. 
	The module name is used for validating a module *after* 
	it is loaded to check if it does really contain the module 
	we're thinking it contains. This is important! */
/* InterpreterPlugin>>#getModuleName */
EXPORT(const char*)
getModuleName(void)
{
	return moduleName;
}
/* FilePlugin>>#initialiseModule */
EXPORT(sqInt)
initialiseModule(void)
{
	return sqFileInit();
}
/* FilePlugin>>#makeDirEntryName:size:createDate:modDate:isDir:fileSize: */
static sqInt
makeDirEntryNamesizecreateDatemodDateisDirfileSize(char *_entryName, sqInt _entryNameSize, sqInt _createDate, sqInt _modifiedDate, sqInt _dirFlag, fileOffset_t _fileSize)
{
	sqInt _createDateOop;
	sqInt _fileSizeOop;
	sqInt _i;
	sqInt _modDateOop;
	sqInt _nameString;
	sqInt _results;
	char *_stringPtr;

	_results = instantiateClassindexableSize(classArray(), 5);
	{
		_nameString = instantiateClassindexableSize(classString(), _entryNameSize);
		{
			_createDateOop = positive32BitIntegerFor(_createDate);
			{
				_modDateOop = positive32BitIntegerFor(_modifiedDate);
				{
					_fileSizeOop = positive64BitIntegerFor(_fileSize);
				}
			}
		}
	}
	_stringPtr = firstIndexableField(_nameString);
	for (_i = 0; _i < _entryNameSize; _i += 1) {
		_stringPtr[_i] = _entryName[_i];
	}
	{
		storePointerofObjectwithValue(0, _results, _nameString);
		storePointerofObjectwithValue(1, _results, _createDateOop);
		storePointerofObjectwithValue(2, _results, _modDateOop);
		storePointerofObjectwithValue(3, _results, ((_dirFlag)
			 ? trueObject()
			 : falseObject()));
		storePointerofObjectwithValue(4, _results, _fileSizeOop);
	}
	return _results;
}
/* FilePlugin>>#makeDirEntryName:size:createDate:modDate:isDir:fileSize:posixPermissions:isSymlink: */
static sqInt
makeDirEntryNamesizecreateDatemodDateisDirfileSizeposixPermissionsisSymlink(char *_entryName, sqInt _entryNameSize, sqInt _createDate, sqInt _modifiedDate, sqInt _dirFlag, fileOffset_t _fileSize, sqInt _posixPermissions, sqInt _symlinkFlag)
{
	sqInt _createDateOop;
	sqInt _fileSizeOop;
	sqInt _i;
	sqInt _modDateOop;
	sqInt _nameString;
	sqInt _posixPermissionsOop;
	sqInt _results;
	char *_stringPtr;

	_results = instantiateClassindexableSize(classArray(), 7);
	{
		_nameString = instantiateClassindexableSize(classString(), _entryNameSize);
		{
			_createDateOop = positive32BitIntegerFor(_createDate);
			{
				_modDateOop = positive32BitIntegerFor(_modifiedDate);
				{
					_fileSizeOop = positive64BitIntegerFor(_fileSize);
					{
						_posixPermissionsOop = positive32BitIntegerFor(_posixPermissions);
					}
				}
			}
		}
	}
	_stringPtr = firstIndexableField(_nameString);
	for (_i = 0; _i < _entryNameSize; _i += 1) {
		_stringPtr[_i] = _entryName[_i];
	}
	{
		storePointerofObjectwithValue(0, _results, _nameString);
		storePointerofObjectwithValue(1, _results, _createDateOop);
		storePointerofObjectwithValue(2, _results, _modDateOop);
		storePointerofObjectwithValue(3, _results, ((_dirFlag)
			 ? trueObject()
			 : falseObject()));
		storePointerofObjectwithValue(4, _results, _fileSizeOop);
		storePointerofObjectwithValue(5, _results, _posixPermissionsOop);
		storePointerofObjectwithValue(6, _results, ((_symlinkFlag)
			 ? trueObject()
			 : falseObject()));
	}
	return _results;
}
/*	Answer the machine address contained in anExternalAddressOop. */
/* FilePlugin>>#pointerFrom: */
static void *
pointerFrom(sqInt _pointerByteArray)
{
	union {void *address; unsigned char bytes[sizeof(void *)];} _addressUnion;
	int _idx;
	unsigned char *_ptr;

	if (!((isKindOf(_pointerByteArray, "ByteArray")) && ((stSizeOf(_pointerByteArray)) == (sizeof(void *))))) {
		return primitiveFailFor(PrimErrBadArgument);
	}
	_ptr = arrayValueOf(_pointerByteArray);
	if (failed()) {
		return null;
	}
	_idx = 0;
	while (_idx < (sizeof(void *))) {
		_addressUnion.bytes[_idx] = _ptr[_idx];
		_idx += 1;
	}
	return _addressUnion.address;
}
/*	Connect to the file with the supplied FILE* and writeFlag. 
	FILE* must be supplied in a byte object (ByteArray) with the platform 
	address size. 
	writeFlag must be a boolean and compatible with the existing file access. */
/* FilePlugin>>#primitiveConnectToFile */
EXPORT(sqInt)
primitiveConnectToFile(void)
{
	void *_cfile;
	sqInt _cfileOop;
	SQFile *_file;
	sqInt _fileOop;
	sqInt _filePointer;
	sqInt _writeFlag;

	_writeFlag = booleanValueOf(stackValue(0));
	_cfileOop = stackValue(1);
	_cfile = pointerFrom(_cfileOop);
	if (failed()) {
		return primitiveFailFor(PrimErrBadArgument);
	}
	/* begin connectToFile:write: */
	_fileOop = instantiateClassindexableSize(classByteArray(), sizeof(SQFile));
	/* begin fileValueOf: */
	if (!((isBytes(_fileOop)) && ((byteSizeOf(_fileOop)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_fileOop);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		sqConnectToFile(_file, _cfile, _writeFlag);
	}
	_filePointer = _fileOop;
	/* end connectToFile:write: */
	if (!(failed())) {
		methodReturnValue(_filePointer);
	}
	return 0;
}
/*	Connect to the existing file identified by fileDescriptor. 
	fileDescriptor must be an integer. 
	writeFlag is aboolean indicating whether to open in read or write mode and 
	must be compatible with the existing file access. */
/* FilePlugin>>#primitiveConnectToFileDescriptor */
EXPORT(sqInt)
primitiveConnectToFileDescriptor(void)
{
	int _fd;
	sqInt _fdPointer;
	SQFile *_file;
	sqInt _fileOop;
	sqInt _filePointer;
	sqInt _writeFlag;

	_writeFlag = booleanValueOf(stackValue(0));
	_fdPointer = stackValue(1);
	if (!(isIntegerObject(_fdPointer))) {
		return primitiveFailFor(PrimErrBadArgument);
	}
	_fd = integerValueOf(_fdPointer);
	if (failed()) {
		return primitiveFailFor(PrimErrBadArgument);
	}
	/* begin connectToFd:write: */
	_fileOop = instantiateClassindexableSize(classByteArray(), sizeof(SQFile));
	/* begin fileValueOf: */
	if (!((isBytes(_fileOop)) && ((byteSizeOf(_fileOop)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_fileOop);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		sqConnectToFileDescriptor(_file, _fd, _writeFlag);
	}
	_filePointer = _fileOop;
	/* end connectToFd:write: */
	if (!(failed())) {
		methodReturnValue(_filePointer);
	}
	return 0;
}
/* FilePlugin>>#primitiveDirectoryCreate */
EXPORT(sqInt)
primitiveDirectoryCreate(void)
{
	sqInt _dirName;
	char *_dirNameIndex;
	sqInt _dirNameSize;

	_dirName = stackValue(0);
	if (!(isBytes(_dirName))) {
		return primitiveFail();
	}
	_dirNameIndex = firstIndexableField(_dirName);
	_dirNameSize = byteSizeOf(_dirName);
	if (!(dir_Create(_dirNameIndex, _dirNameSize))) {
		return primitiveFail();
	}
	pop(1);
	return 0;
}
/* FilePlugin>>#primitiveDirectoryDelete */
EXPORT(sqInt)
primitiveDirectoryDelete(void)
{
	sqInt _dirName;
	char *_dirNameIndex;
	sqInt _dirNameSize;

	_dirName = stackValue(0);
	if (!(isBytes(_dirName))) {
		return primitiveFail();
	}
	_dirNameIndex = firstIndexableField(_dirName);
	_dirNameSize = byteSizeOf(_dirName);
	if (!(dir_Delete(_dirNameIndex, _dirNameSize))) {
		return primitiveFail();
	}
	pop(1);
	return 0;
}
/* FilePlugin>>#primitiveDirectoryDelimitor */
EXPORT(sqInt)
primitiveDirectoryDelimitor(void)
{
	if ((interpreterProxy->minorVersion()) >= 13) {
		popthenPush(1, characterObjectOf(dir_Delimitor()));
	}
 else {
		primitiveFail();
	}
	return 0;
}
/*	Two arguments - directory path, and simple file name; 
	returns an array (see primitiveDirectoryLookup) describing the file or 
	directory, or nil if it does not exist.  
	Primitive fails if the outer path does not identify a readable directory. 
	(This is a lookup-by-name variant of primitiveDirectoryLookup.) */
/* FilePlugin>>#primitiveDirectoryEntry */
EXPORT(sqInt)
primitiveDirectoryEntry(void)
{
	sqInt _createDate;
	sqInt _dirFlag;
	char _entryName[256];
	sqInt _entryNameSize;
	fileOffset_t _fileSize;
	sqInt _modifiedDate;
	sqInt _pathName;
	char *_pathNameIndex;
	sqInt _pathNameSize;
	sqInt _posixPermissions;
	char *_reqNameIndex;
	sqInt _reqNameSize;
	sqInt _requestedName;
	sqInt _status;
	sqInt _symlinkFlag;
	sqInt _v;

	_createDate = 0;
	_dirFlag = 0;
	_entryNameSize = 0;
	_modifiedDate = 0;
	_posixPermissions = 0;
	_symlinkFlag = 0;
	_v = 0;
	_requestedName = stackValue(0);
	_pathName = stackValue(1);
	if (!(isBytes(_pathName))) {
		return primitiveFail();
	}
	_pathNameIndex = firstIndexableField(_pathName);
	_pathNameSize = byteSizeOf(_pathName);
	_reqNameIndex = firstIndexableField(_requestedName);
	_reqNameSize = byteSizeOf(_requestedName);
	_status = dir_EntryLookup(_pathNameIndex, _pathNameSize, _reqNameIndex, _reqNameSize, _entryName, &_entryNameSize, &_createDate, &_modifiedDate, &_dirFlag, &_fileSize, &_posixPermissions, &_symlinkFlag);
	if (failed()) {
		return null;
	}
	if (_status == DirNoMoreEntries) {
		popthenPush(3, nilObject());
		return null;
	}
	if (_status == DirBadPath) {
		return primitiveFail();
	}
	popthenPush(3, makeDirEntryNamesizecreateDatemodDateisDirfileSizeposixPermissionsisSymlink(_entryName, _entryNameSize, _createDate, _modifiedDate, _dirFlag, _fileSize, _posixPermissions, _symlinkFlag));
	return 0;
}
/* FilePlugin>>#primitiveDirectoryGetMacTypeAndCreator */
EXPORT(sqInt)
primitiveDirectoryGetMacTypeAndCreator(void)
{
	sqInt _creatorString;
	char *_creatorStringIndex;
	sqInt _fileName;
	char *_fileNameIndex;
	sqInt _fileNameSize;
	sqInt _typeString;
	char *_typeStringIndex;

	_creatorString = stackValue(0);
	_typeString = stackValue(1);
	_fileName = stackValue(2);
	if (!((isBytes(_creatorString)) && ((byteSizeOf(_creatorString)) == 4))) {
		return primitiveFail();
	}
	if (!((isBytes(_typeString)) && ((byteSizeOf(_typeString)) == 4))) {
		return primitiveFail();
	}
	if (!(isBytes(_fileName))) {
		return primitiveFail();
	}
	_creatorStringIndex = firstIndexableField(_creatorString);
	_typeStringIndex = firstIndexableField(_typeString);
	_fileNameIndex = firstIndexableField(_fileName);
	_fileNameSize = byteSizeOf(_fileName);
	if (!(dir_GetMacFileTypeAndCreator(_fileNameIndex, _fileNameSize, _typeStringIndex, _creatorStringIndex))) {
		return primitiveFail();
	}
	pop(3);
	return 0;
}
/* FilePlugin>>#primitiveDirectoryLookup */
EXPORT(sqInt)
primitiveDirectoryLookup(void)
{
	sqInt _createDate;
	sqInt _dirFlag;
	char _entryName[256];
	sqInt _entryNameSize;
	fileOffset_t _fileSize;
	sqInt _index;
	sqInt _modifiedDate;
	sqInt _pathName;
	char *_pathNameIndex;
	sqInt _pathNameSize;
	sqInt _posixPermissions;
	sqInt _status;
	sqInt _symlinkFlag;
	sqInt _v;

	_createDate = 0;
	_dirFlag = 0;
	_entryNameSize = 0;
	_modifiedDate = 0;
	_posixPermissions = 0;
	_symlinkFlag = 0;
	_v = 0;
	_index = stackIntegerValue(0);
	_pathName = stackValue(1);
	if (!(isBytes(_pathName))) {
		return primitiveFail();
	}
	_pathNameIndex = firstIndexableField(_pathName);
	_pathNameSize = byteSizeOf(_pathName);
	_status = dir_Lookup(_pathNameIndex, _pathNameSize, _index, _entryName, &_entryNameSize, &_createDate, &_modifiedDate, &_dirFlag, &_fileSize, &_posixPermissions, &_symlinkFlag);
	if (failed()) {
		return null;
	}
	if (_status == DirNoMoreEntries) {
		popthenPush(3, nilObject());
		return null;
	}
	if (_status == DirBadPath) {
		return primitiveFail();
	}
	popthenPush(3, makeDirEntryNamesizecreateDatemodDateisDirfileSizeposixPermissionsisSymlink(_entryName, _entryNameSize, _createDate, _modifiedDate, _dirFlag, _fileSize, _posixPermissions, _symlinkFlag));
	return 0;
}
/* FilePlugin>>#primitiveDirectorySetMacTypeAndCreator */
EXPORT(sqInt)
primitiveDirectorySetMacTypeAndCreator(void)
{
	sqInt _creatorString;
	char *_creatorStringIndex;
	sqInt _fileName;
	char *_fileNameIndex;
	sqInt _fileNameSize;
	sqInt _typeString;
	char *_typeStringIndex;

	_creatorString = stackValue(0);
	_typeString = stackValue(1);
	_fileName = stackValue(2);
	if (!((isBytes(_creatorString)) && ((isBytes(_typeString)) && ((isBytes(_fileName)) && (((byteSizeOf(_creatorString)) == 4) && ((byteSizeOf(_typeString)) == 4)))))) {
		return primitiveFail();
	}
	_creatorStringIndex = firstIndexableField(_creatorString);
	_typeStringIndex = firstIndexableField(_typeString);
	_fileNameIndex = firstIndexableField(_fileName);
	_fileNameSize = byteSizeOf(_fileName);
	if (!(dir_SetMacFileTypeAndCreator(_fileNameIndex, _fileNameSize, _typeStringIndex, _creatorStringIndex))) {
		return primitiveFail();
	}
	pop(3);
	return 0;
}
/* FilePlugin>>#primitiveFileAtEnd */
EXPORT(sqInt)
primitiveFileAtEnd(void)
{
	sqInt _atEnd;
	SQFile *_file;
	sqInt _objectPointer;

	/* begin fileValueOf: */
	_objectPointer = stackValue(0);
	_atEnd = 0;
	if (!((isBytes(_objectPointer)) && ((byteSizeOf(_objectPointer)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_objectPointer);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		_atEnd = sqFileAtEnd(_file);
	}
	if (!(failed())) {
		methodReturnBool(_atEnd);
	}
	return 0;
}
/* FilePlugin>>#primitiveFileClose */
EXPORT(sqInt)
primitiveFileClose(void)
{
	SQFile *_file;
	sqInt _objectPointer;

	/* begin fileValueOf: */
	_objectPointer = stackValue(0);
	if (!((isBytes(_objectPointer)) && ((byteSizeOf(_objectPointer)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_objectPointer);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		sqFileClose(_file);
	}
	if (!(failed())) {
		pop(1);
	}
	return 0;
}
/* FilePlugin>>#primitiveFileDelete */
EXPORT(sqInt)
primitiveFileDelete(void)
{
	char *_nameIndex;
	sqInt _namePointer;
	sqInt _nameSize;

	_namePointer = stackValue(0);
	if (!(isBytes(_namePointer))) {
		return primitiveFail();
	}
	_nameIndex = firstIndexableField(_namePointer);
	_nameSize = byteSizeOf(_namePointer);
	sqFileDeleteNameSize(_nameIndex, _nameSize);
	if (!(failed())) {
		pop(1);
	}
	return 0;
}
/*	Allow to test if the standard input/output files are from a console or not 
	Return values: 
	* -1 - Error 
	* 0 - no console (windows only) 
	* 1 - normal terminal (unix terminal / windows console) 
	* 2 - pipe 
	* 3 - file 
	* 4 - cygwin terminal (windows only) */
/* FilePlugin>>#primitiveFileDescriptorType */
EXPORT(sqInt)
primitiveFileDescriptorType(void)
{
	int _fd;
	sqInt _fdPointer;
	sqInt _fileType;

	_fdPointer = stackValue(0);
	if (!(isIntegerObject(_fdPointer))) {
		return primitiveFailFor(PrimErrBadArgument);
	}
	_fd = integerValueOf(_fdPointer);
	if (failed()) {
		return primitiveFailFor(PrimErrBadArgument);
	}
	_fileType = sqFileDescriptorType(_fd);
	methodReturnInteger(_fileType);
	return 0;
}
/* FilePlugin>>#primitiveFileFlush */
EXPORT(sqInt)
primitiveFileFlush(void)
{
	SQFile *_file;
	sqInt _objectPointer;

	/* begin fileValueOf: */
	_objectPointer = stackValue(0);
	if (!((isBytes(_objectPointer)) && ((byteSizeOf(_objectPointer)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_objectPointer);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		sqFileFlush(_file);
	}
	if (!(failed())) {
		pop(1);
	}
	return 0;
}
/* FilePlugin>>#primitiveFileGetPosition */
EXPORT(sqInt)
primitiveFileGetPosition(void)
{
	SQFile *_file;
	sqInt _objectPointer;
	fileOffset_t _position;

	/* begin fileValueOf: */
	_objectPointer = stackValue(0);
	if (!((isBytes(_objectPointer)) && ((byteSizeOf(_objectPointer)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_objectPointer);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		_position = sqFileGetPosition(_file);
	}
	if (!(failed())) {
		methodReturnValue(positive64BitIntegerFor(_position));
	}
	return 0;
}
/* FilePlugin>>#primitiveFileOpen */
EXPORT(sqInt)
primitiveFileOpen(void)
{
	sqInt _filePointer;
	char *_nameIndex;
	sqInt _namePointer;
	sqInt _nameSize;
	sqInt _writeFlag;

	_writeFlag = booleanValueOf(stackValue(0));
	_namePointer = stackValue(1);
	if (!(isBytes(_namePointer))) {
		return primitiveFail();
	}
	_nameIndex = firstIndexableField(_namePointer);
	_nameSize = byteSizeOf(_namePointer);
	_filePointer = fileOpenNamesizewrite(_nameIndex, _nameSize, _writeFlag);
	if (!(failed())) {
		methodReturnValue(_filePointer);
	}
	return 0;
}
/* FilePlugin>>#primitiveFileOpenNew */
EXPORT(sqInt)
primitiveFileOpenNew(void)
{
	sqInt _filePointer;
	char *_nameIndex;
	sqInt _namePointer;
	sqInt _nameSize;

	_namePointer = stackValue(0);
	if (!(isBytes(_namePointer))) {
		return primitiveFail();
	}
	_nameIndex = firstIndexableField(_namePointer);
	_nameSize = byteSizeOf(_namePointer);
	_filePointer = fileOpenNewNamesize(_nameIndex, _nameSize);
	if (!(failed())) {
		methodReturnValue(_filePointer);
	}
	return 0;
}
/* FilePlugin>>#primitiveFileRead */
EXPORT(sqInt)
primitiveFileRead(void)
{
	sqInt _array;
	sqInt _bytesRead;
	sqInt _count;
	sqInt _elementSize;
	SQFile * _file;
	sqInt _objectPointer;
	sqInt _slotSize;
	sqInt _startIndex;

	_count = positiveMachineIntegerValueOf(stackValue(0));
	_startIndex = positiveMachineIntegerValueOf(stackValue(1));
	_array = stackValue(2);
	/* begin fileValueOf: */
	_objectPointer = stackValue(3);
	if (!((isBytes(_objectPointer)) && ((byteSizeOf(_objectPointer)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_objectPointer);
	l2:
	;
	/* end fileValueOf: */
	if ((failed()) || (!(isWordsOrBytes(_array)))) {
		primitiveFailFor(PrimErrBadArgument);
	} else {
		_slotSize = slotSizeOf(_array);
		if ((_startIndex >= 1) && (((_startIndex + _count) - 1) <= _slotSize)) {
			_elementSize = ((_slotSize == 0)
				 ? 1
				 : (byteSizeOf(_array)) / _slotSize);
			_bytesRead = sqFileReadIntoAt(_file, _count * _elementSize, ((char *) (firstIndexableField(_array)) ), (_startIndex - 1) * _elementSize);
			if (!(failed())) {
				methodReturnValue(integerObjectOf(_bytesRead / _elementSize));
			}
		} else {
			primitiveFailFor(PrimErrBadIndex);
		}
	}
	return 0;
}
/* FilePlugin>>#primitiveFileRename */
EXPORT(sqInt)
primitiveFileRename(void)
{
	char *_newNameIndex;
	sqInt _newNamePointer;
	sqInt _newNameSize;
	char *_oldNameIndex;
	sqInt _oldNamePointer;
	sqInt _oldNameSize;

	_newNamePointer = stackValue(0);
	_oldNamePointer = stackValue(1);
	if (!((isBytes(_newNamePointer)) && (isBytes(_oldNamePointer)))) {
		return primitiveFail();
	}
	_newNameIndex = firstIndexableField(_newNamePointer);
	_newNameSize = byteSizeOf(_newNamePointer);
	_oldNameIndex = firstIndexableField(_oldNamePointer);
	_oldNameSize = byteSizeOf(_oldNamePointer);
	sqFileRenameOldSizeNewSize(_oldNameIndex, _oldNameSize, _newNameIndex, _newNameSize);
	if (!(failed())) {
		pop(2);
	}
	return 0;
}
/* FilePlugin>>#primitiveFileSetPosition */
EXPORT(sqInt)
primitiveFileSetPosition(void)
{
	SQFile *_file;
	fileOffset_t _newPosition;
	sqInt _objectPointer;

	if ((byteSizeOf(stackValue(0))) > (sizeof(fileOffset_t))) {
		return primitiveFail();
	}
	_newPosition = positive64BitValueOf(stackValue(0));
	/* begin fileValueOf: */
	_objectPointer = stackValue(1);
	if (!((isBytes(_objectPointer)) && ((byteSizeOf(_objectPointer)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_objectPointer);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		sqFileSetPosition(_file, _newPosition);
	}
	if (!(failed())) {
		pop(2);
	}
	return 0;
}
/* FilePlugin>>#primitiveFileSize */
EXPORT(sqInt)
primitiveFileSize(void)
{
	SQFile *_file;
	sqInt _objectPointer;
	fileOffset_t _size;

	/* begin fileValueOf: */
	_objectPointer = stackValue(0);
	if (!((isBytes(_objectPointer)) && ((byteSizeOf(_objectPointer)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_objectPointer);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		_size = sqFileSize(_file);
	}
	if (!(failed())) {
		methodReturnValue(positive64BitIntegerFor(_size));
	}
	return 0;
}
/*	Answer an Array of file handles for standard in, standard out and standard 
	error, with nil in entries that are unvailable, e.g. because the platform 
	does not provide 
	standard error, etc. Fail if an error occurs determining the stdio 
	handles, if the security plugin denies access or if memory runs out. */
/* FilePlugin>>#primitiveFileStdioHandles */
EXPORT(sqInt)
primitiveFileStdioHandles(void)
{
	SQFile _fileRecords[3];
	sqInt _index;
	sqInt _result;
	sqInt _validMask;

	_validMask = sqFileStdioHandlesInto(_fileRecords);
	if (_validMask < 0) {
		return primitiveFailForOSError(_validMask);
	}
	_result = instantiateClassindexableSize(classArray(), 3);
	if (_result == null) {
		return primitiveFailFor(PrimErrNoMemory);
	}
	pushRemappableOop(_result);
	for (_index = 0; _index <= 2; _index += 1) {
		if ((_validMask & (1U << _index)) != 0) {
			_result = instantiateClassindexableSize(classByteArray(), sizeof(SQFile));
			if (_result == null) {
				popRemappableOop();
				return primitiveFailFor(PrimErrNoMemory);
			}
			storePointerofObjectwithValue(_index, topRemappableOop(), _result);
			memcpy(firstIndexableField(_result), &(_fileRecords[_index]), sizeof(SQFile));
		}
	}
	_result = popRemappableOop();
	methodReturnValue(_result);
	return 0;
}
/* FilePlugin>>#primitiveFileSync */
EXPORT(sqInt)
primitiveFileSync(void)
{
	SQFile *_file;
	sqInt _objectPointer;

	/* begin fileValueOf: */
	_objectPointer = stackValue(0);
	if (!((isBytes(_objectPointer)) && ((byteSizeOf(_objectPointer)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_objectPointer);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		sqFileSync(_file);
	}
	if (!(failed())) {
		pop(1);
	}
	return 0;
}
/*	ftruncate is not an ansi function so we have a macro to point to a 
	suitable platform implementation */
/* FilePlugin>>#primitiveFileTruncate */
EXPORT(sqInt)
primitiveFileTruncate(void)
{
	SQFile *_file;
	sqInt _objectPointer;
	fileOffset_t _truncatePosition;

	if (!(isIntegerObject(stackValue(0)))) {
		if ((byteSizeOf(stackValue(0))) > (sizeof(fileOffset_t))) {
			return primitiveFail();
		}
	}
	_truncatePosition = positive64BitValueOf(stackValue(0));
	/* begin fileValueOf: */
	_objectPointer = stackValue(1);
	if (!((isBytes(_objectPointer)) && ((byteSizeOf(_objectPointer)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_objectPointer);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		sqFileTruncate(_file, _truncatePosition);
	}
	if (!(failed())) {
		pop(2);
	}
	return 0;
}
/* FilePlugin>>#primitiveFileWrite */
EXPORT(sqInt)
primitiveFileWrite(void)
{
	sqInt _array;
	sqInt _bytesWritten;
	size_t _count;
	size_t _elementSize;
	SQFile *_file;
	sqInt _objectPointer;
	size_t _slotSize;
	size_t _startIndex;

	_count = positiveMachineIntegerValueOf(stackValue(0));
	_startIndex = positiveMachineIntegerValueOf(stackValue(1));
	_array = stackValue(2);
	/* begin fileValueOf: */
	_objectPointer = stackValue(3);
	if (!((isBytes(_objectPointer)) && ((byteSizeOf(_objectPointer)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_objectPointer);
	l2:
	;
	/* end fileValueOf: */
	if ((failed()) || (!(isWordsOrBytes(_array)))) {
		return primitiveFailFor(PrimErrBadArgument);
	}
	_slotSize = slotSizeOf(_array);
	if (!((_startIndex >= 1) && (((_startIndex + _count) - 1) <= _slotSize))) {
		return primitiveFailFor(PrimErrBadIndex);
	}
	_elementSize = ((_slotSize == 0)
		 ? 1
		 : (byteSizeOf(_array)) / _slotSize);
	_bytesWritten = sqFileWriteFromAt(_file, _count * _elementSize, ((char *) (firstIndexableField(_array)) ), (_startIndex - 1) * _elementSize);
	if (!(failed())) {
		methodReturnValue(integerObjectOf(_bytesWritten / _elementSize));
	}
	return 0;
}
/*	This primitive set a semaphore passed as a semaphoreIndex to be signalled 
	when there is data in the File / Pipe, and it will not block */
/* FilePlugin>>#primitiveWaitForDataWithSemaphore */
EXPORT(sqInt)
primitiveWaitForDataWithSemaphore(void)
{
	SQFile *_file;
	sqInt _objectPointer;
	sqInt _semaphoreIndex;

	_semaphoreIndex = integerValueOf(stackValue(0));
	/* begin fileValueOf: */
	_objectPointer = stackValue(1);
	if (!((isBytes(_objectPointer)) && ((byteSizeOf(_objectPointer)) == (sizeof(SQFile))))) {
		primitiveFail();
		_file = null;
		goto l2;
	}
	_file = firstIndexableField(_objectPointer);
	l2:
	;
	/* end fileValueOf: */
	if (!(failed())) {
		waitForDataonSemaphoreIndex(_file, _semaphoreIndex);
	}
	if (!(failed())) {
		pop(2);
	}
	return 0;
}
/*	Note: This is coded so that it can be run in Squeak. */
/* InterpreterPlugin>>#setInterpreter: */
EXPORT(sqInt)
setInterpreter(struct VirtualMachine *_anInterpreter)
{
	sqInt _ok;

	interpreterProxy = _anInterpreter;
	_ok = ((interpreterProxy->majorVersion()) == (VM_PROXY_MAJOR)) && ((interpreterProxy->minorVersion()) >= (VM_PROXY_MINOR));
	if (_ok) {
		
#    if !(defined(SQUEAK_BUILTIN_PLUGIN))
		{
			
			{
				{
					arrayValueOf = interpreterProxy->arrayValueOf;
				}
				{
					booleanValueOf = interpreterProxy->booleanValueOf;
				}
				{
					byteSizeOf = interpreterProxy->byteSizeOf;
				}
				
#        if VM_PROXY_MAJOR > 1 || (VM_PROXY_MAJOR == 1 && VM_PROXY_MINOR >= 13)
				{
					characterObjectOf = interpreterProxy->characterObjectOf;
				}
#        else /* VM_PROXY_MAJOR > 1 || (VM_PROXY_MAJOR == 1 && VM_PROXY_MINOR >= 13) */
				{
					
#          if !(defined(characterObjectOf))
					{
						
						characterObjectOf = 0;
					}
#          endif /* !(defined(characterObjectOf)) */
				}
#        endif /* VM_PROXY_MAJOR > 1 || (VM_PROXY_MAJOR == 1 && VM_PROXY_MINOR >= 13) */
				{
					classArray = interpreterProxy->classArray;
				}
				{
					classByteArray = interpreterProxy->classByteArray;
				}
				{
					classString = interpreterProxy->classString;
				}
				{
					failed = interpreterProxy->failed;
				}
				{
					falseObject = interpreterProxy->falseObject;
				}
				{
					firstIndexableField = interpreterProxy->firstIndexableField;
				}
				{
					instantiateClassindexableSize = interpreterProxy->instantiateClassindexableSize;
				}
				{
					integerObjectOf = interpreterProxy->integerObjectOf;
				}
				{
					integerValueOf = interpreterProxy->integerValueOf;
				}
				{
					isKindOf = interpreterProxy->isKindOf;
				}
				{
					isBytes = interpreterProxy->isBytes;
				}
				{
					isIntegerObject = interpreterProxy->isIntegerObject;
				}
				{
					isWordsOrBytes = interpreterProxy->isWordsOrBytes;
				}
				{
					methodReturnBool = interpreterProxy->methodReturnBool;
				}
				{
					methodReturnInteger = interpreterProxy->methodReturnInteger;
				}
				{
					methodReturnValue = interpreterProxy->methodReturnValue;
				}
				{
					nilObject = interpreterProxy->nilObject;
				}
				{
					pop = interpreterProxy->pop;
				}
				{
					popthenPush = interpreterProxy->popthenPush;
				}
				{
					popRemappableOop = interpreterProxy->popRemappableOop;
				}
				{
					positive32BitIntegerFor = interpreterProxy->positive32BitIntegerFor;
				}
				{
					positive64BitIntegerFor = interpreterProxy->positive64BitIntegerFor;
				}
				{
					positive64BitValueOf = interpreterProxy->positive64BitValueOf;
				}
				{
					positiveMachineIntegerValueOf = interpreterProxy->positiveMachineIntegerValueOf;
				}
				{
					primitiveFail = interpreterProxy->primitiveFail;
				}
				{
					primitiveFailFor = interpreterProxy->primitiveFailFor;
				}
				
#        if VM_PROXY_MAJOR > 1 || (VM_PROXY_MAJOR == 1 && VM_PROXY_MINOR >= 14)
				{
					primitiveFailForOSError = interpreterProxy->primitiveFailForOSError;
				}
#        else /* VM_PROXY_MAJOR > 1 || (VM_PROXY_MAJOR == 1 && VM_PROXY_MINOR >= 14) */
				{
					
#          if !(defined(primitiveFailForOSError))
					{
						
						primitiveFailForOSError = 0;
					}
#          endif /* !(defined(primitiveFailForOSError)) */
				}
#        endif /* VM_PROXY_MAJOR > 1 || (VM_PROXY_MAJOR == 1 && VM_PROXY_MINOR >= 14) */
				{
					pushRemappableOop = interpreterProxy->pushRemappableOop;
				}
				{
					slotSizeOf = interpreterProxy->slotSizeOf;
				}
				{
					stSizeOf = interpreterProxy->stSizeOf;
				}
				{
					stackIntegerValue = interpreterProxy->stackIntegerValue;
				}
				{
					stackValue = interpreterProxy->stackValue;
				}
				{
					storePointerofObjectwithValue = interpreterProxy->storePointerofObjectwithValue;
				}
				{
					topRemappableOop = interpreterProxy->topRemappableOop;
				}
				{
					trueObject = interpreterProxy->trueObject;
				}
			}
		}
#    endif /* !(defined(SQUEAK_BUILTIN_PLUGIN)) */
	}
	return _ok;
}
/*	Exported entry point for the VM. Needed for image saving only and no-op on 
	anything but Macs. */
/* FilePlugin>>#setMacFile:Type:AndCreator: */
EXPORT(sqInt)
setMacFileTypeAndCreator(char *fileName, char *typeString, char *creatorString)
{
	return dir_SetMacFileTypeAndCreator(fileName, strlen(fileName), typeString, creatorString);
}
/* FilePlugin>>#shutdownModule */
EXPORT(sqInt)
shutdownModule(void)
{
	return sqFileShutdown();
}


#ifdef SQUEAK_BUILTIN_PLUGIN

static char _m[] = "FilePlugin";
void* FilePlugin_exports[][3] = {
	{(void*)_m, "fileOpenNamesizewrite", (void*)fileOpenNamesizewrite},
	{(void*)_m, "fileOpenNewNamesize", (void*)fileOpenNewNamesize},
	{(void*)_m, "getModuleName", (void*)getModuleName},
	{(void*)_m, "initialiseModule", (void*)initialiseModule},
	{(void*)_m, "primitiveConnectToFile\000\001", (void*)primitiveConnectToFile},
	{(void*)_m, "primitiveConnectToFileDescriptor\000\000", (void*)primitiveConnectToFileDescriptor},
	{(void*)_m, "primitiveDirectoryCreate\000\001", (void*)primitiveDirectoryCreate},
	{(void*)_m, "primitiveDirectoryDelete\000\001", (void*)primitiveDirectoryDelete},
	{(void*)_m, "primitiveDirectoryDelimitor\000\377", (void*)primitiveDirectoryDelimitor},
	{(void*)_m, "primitiveDirectoryEntry\000\001", (void*)primitiveDirectoryEntry},
	{(void*)_m, "primitiveDirectoryGetMacTypeAndCreator\000\001", (void*)primitiveDirectoryGetMacTypeAndCreator},
	{(void*)_m, "primitiveDirectoryLookup\000\001", (void*)primitiveDirectoryLookup},
	{(void*)_m, "primitiveDirectorySetMacTypeAndCreator\000\001", (void*)primitiveDirectorySetMacTypeAndCreator},
	{(void*)_m, "primitiveFileAtEnd\000\001", (void*)primitiveFileAtEnd},
	{(void*)_m, "primitiveFileClose\000\001", (void*)primitiveFileClose},
	{(void*)_m, "primitiveFileDelete\000\001", (void*)primitiveFileDelete},
	{(void*)_m, "primitiveFileDescriptorType\000\000", (void*)primitiveFileDescriptorType},
	{(void*)_m, "primitiveFileFlush\000\001", (void*)primitiveFileFlush},
	{(void*)_m, "primitiveFileGetPosition\000\001", (void*)primitiveFileGetPosition},
	{(void*)_m, "primitiveFileOpen\000\002", (void*)primitiveFileOpen},
	{(void*)_m, "primitiveFileOpenNew\000\002", (void*)primitiveFileOpenNew},
	{(void*)_m, "primitiveFileRead\000\001", (void*)primitiveFileRead},
	{(void*)_m, "primitiveFileRename\000\001", (void*)primitiveFileRename},
	{(void*)_m, "primitiveFileSetPosition\000\001", (void*)primitiveFileSetPosition},
	{(void*)_m, "primitiveFileSize\000\001", (void*)primitiveFileSize},
	{(void*)_m, "primitiveFileStdioHandles\000\377", (void*)primitiveFileStdioHandles},
	{(void*)_m, "primitiveFileSync\000\001", (void*)primitiveFileSync},
	{(void*)_m, "primitiveFileTruncate\000\001", (void*)primitiveFileTruncate},
	{(void*)_m, "primitiveFileWrite\000\001", (void*)primitiveFileWrite},
	{(void*)_m, "primitiveWaitForDataWithSemaphore\000\001", (void*)primitiveWaitForDataWithSemaphore},
	{(void*)_m, "setInterpreter", (void*)setInterpreter},
	{(void*)_m, "setMacFileTypeAndCreator", (void*)setMacFileTypeAndCreator},
	{(void*)_m, "shutdownModule\000\377", (void*)shutdownModule},
	{NULL, NULL, NULL}
};

#else /* ifdef SQ_BUILTIN_PLUGIN */

EXPORT(signed char) primitiveConnectToFileAccessorDepth = 1;
EXPORT(signed char) primitiveConnectToFileDescriptorAccessorDepth = 0;
EXPORT(signed char) primitiveDirectoryCreateAccessorDepth = 1;
EXPORT(signed char) primitiveDirectoryDeleteAccessorDepth = 1;
EXPORT(signed char) primitiveDirectoryEntryAccessorDepth = 1;
EXPORT(signed char) primitiveDirectoryGetMacTypeAndCreatorAccessorDepth = 1;
EXPORT(signed char) primitiveDirectoryLookupAccessorDepth = 1;
EXPORT(signed char) primitiveDirectorySetMacTypeAndCreatorAccessorDepth = 1;
EXPORT(signed char) primitiveFileAtEndAccessorDepth = 1;
EXPORT(signed char) primitiveFileCloseAccessorDepth = 1;
EXPORT(signed char) primitiveFileDeleteAccessorDepth = 1;
EXPORT(signed char) primitiveFileDescriptorTypeAccessorDepth = 0;
EXPORT(signed char) primitiveFileFlushAccessorDepth = 1;
EXPORT(signed char) primitiveFileGetPositionAccessorDepth = 1;
EXPORT(signed char) primitiveFileOpenAccessorDepth = 2;
EXPORT(signed char) primitiveFileOpenNewAccessorDepth = 2;
EXPORT(signed char) primitiveFileReadAccessorDepth = 1;
EXPORT(signed char) primitiveFileRenameAccessorDepth = 1;
EXPORT(signed char) primitiveFileSetPositionAccessorDepth = 1;
EXPORT(signed char) primitiveFileSizeAccessorDepth = 1;
EXPORT(signed char) primitiveFileSyncAccessorDepth = 1;
EXPORT(signed char) primitiveFileTruncateAccessorDepth = 1;
EXPORT(signed char) primitiveFileWriteAccessorDepth = 1;
EXPORT(signed char) primitiveWaitForDataWithSemaphoreAccessorDepth = 1;

#endif /* ifdef SQ_BUILTIN_PLUGIN */
