#ifndef PHAROVM_CONFIG_H
#define PHAROVM_CONFIG_H

#pragma once

/* Common configurations */
#define VM_NAME "Pharo"
#define DEFAULT_IMAGE_NAME "Pharo.image"

/* Availability of Functions */

#define HAVE_DIRENT_H
/* #undef HAVE_FEATURES_H */
#define HAVE_UNISTD_H 1
/* #undef HAVE_NDIR_H */
/* #undef HAVE_SYS_NDIR_H */
/* #undef HAVE_SYS_DIR_H */
/* #undef HAVE_SYS_FILIO_H */
#define HAVE_SYS_TIME_H
/* #undef HAVE_EXECINFO_H */

/* #undef AVE_DLFCN_H */
/* #undef HAVE_LIBDL */
/* #undef HAVE_DYLD */
/* #undef HAVE_TM_GMTOFF */

/* architecture */

#define OS_TYPE "Win32"

#define VM_HOST "CYGWIN-3.5.7-1.x86_64"
#define VM_HOST_CPU "x86_64"
#define VM_HOST_OS "Win64"
#define VM_TARGET "CYGWIN-3.5.7-1.x86_64"
#define VM_TARGET_CPU "x86_64"
#define VM_TARGET_OS "Win64"

/* widths of primitive types */

#define SIZEOF_INT 4
#define SIZEOF_LONG 4
#define SIZEOF_LONG_LONG 8
#define SIZEOF_VOID_P 8

#define squeakInt64 long long

/* #undef HAVE_SYS_UUID_H */
/* #undef HAVE_UUID_UUID_H */
/* #undef HAVE_UUID_H */

/* #undef HAVE_UUIDGEN */
/* #undef HAVE_UUID_GENERATE */

#define PHARO_VM_IN_WORKER_THREAD

#if defined(_MSC_VER)
#define VM_BUILD_STRING VM_NAME " v10.3.8 built on " __DATE__ " " __TIME__ " Compiler: Visual C"
#define COMPILER_VERSION "Visual C"
#else
#define VM_BUILD_STRING VM_NAME " v10.3.8 built on " __DATE__ " " __TIME__" Compiler: " __VERSION__
#define COMPILER_VERSION __VERSION__
#endif

#define VM_BUILD_SOURCE_STRING "v10.3.8+2.a33207fb3 - Commit: a33207fb3 - Date: 2025-11-17 10:47:36 +0100"

#define ALWAYS_INTERACTIVE OFF

/*
 * We require that VM_LABEL does nothing.
 * We should actually cleanup all the places where this is set/used in the VM
 */

#define VM_LABEL(foo)		0

#endif //PHAROVM_CONFIG_H
